<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Laporan Laba Rugi</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
            border-bottom: 2px solid #000;
            padding-bottom: 10px;
        }
        .header p {
            margin: 3px 0;
            font-size: 10px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        table.bordered {
            border: 1px solid #000;
        }
        table.bordered th,
        table.bordered td {
            border: 1px solid #000;
            padding: 8px;
        }
        table.detail td {
            padding: 5px 10px;
        }
        .text-right {
            text-align: right;
        }
        .text-center {
            text-align: center;
        }
        .font-bold {
            font-weight: bold;
        }
        .bg-gray {
            background-color: #f0f0f0;
        }
        .bg-success {
            background-color: #d4edda;
        }
        .bg-danger {
            background-color: #f8d7da;
        }
        .indent {
            padding-left: 30px;
        }
    </style>
</head>
<body>
    <?php
        $logoPath = public_path('logo/logo-umi.png');
        $logoExists = file_exists($logoPath);
    ?>

    <div class="header">
        <div style="
            display: inline-flex !important;
            align-items: center !important;
            justify-content: center;
            width: 100%;
            white-space: nowrap;
        ">
            <?php if($logoExists): ?>
                <img src="<?php echo e($logoPath); ?>"
                    style="
                        height:50px;
                        width:50px;
                        display:inline-block !important;
                        vertical-align: middle;
                        margin-right:10px;
                    ">
            <?php endif; ?>

            <span style="
                font-size:24px;
                font-weight:bold;
                display:inline-block;
                vertical-align: middle;
            ">
                UMI CELL
            </span>
        </div>

        <p>Jl. Raya Semarang-Boja, Jatisari, Kec. Mijen, Kota Semarang Jawa Tengah 50275</p>
        <p>Telp: 0882005564342</p>
    </div>

    <h3 style="text-align: center; margin-bottom: 5px;">LAPORAN LABA RUGI</h3>
    <p style="text-align: center; margin-top: 0;">
        Periode: <?php echo e(date('d M Y', strtotime($startDate))); ?> - <?php echo e(date('d M Y', strtotime($endDate))); ?><br>
        <?php if($branch): ?>
            Cabang: <?php echo e($branch->name); ?>

        <?php else: ?>
            Cabang: Semua Cabang
        <?php endif; ?>
    </p>

    <table class="bordered">
        <tbody>
            <tr class="bg-gray">
                <td colspan="2" class="font-bold">PENDAPATAN</td>
            </tr>
            <tr>
                <td class="indent">Penjualan</td>
                <td class="text-right">Rp <?php echo e(number_format($totalRevenue, 0, ',', '.')); ?></td>
            </tr>
            <tr>
                <td class="indent">Diskon Penjualan</td>
                <td class="text-right">(Rp <?php echo e(number_format($totalSalesDiscount, 0, ',', '.')); ?>)</td>
            </tr>
            <tr>
                <td class="indent">Pajak</td>
                <td class="text-right">Rp <?php echo e(number_format($totalSalesTax, 0, ',', '.')); ?></td>
            </tr>
            <tr class="font-bold">
                <td>Total Pendapatan Bersih</td>
                <td class="text-right">Rp <?php echo e(number_format($totalRevenue - $totalSalesDiscount + $totalSalesTax, 0, ',', '.')); ?></td>
            </tr>

            <tr class="bg-gray">
                <td colspan="2" class="font-bold">HARGA POKOK PENJUALAN (HPP)</td>
            </tr>
            <tr>
                <td class="indent">HPP</td>
                <td class="text-right">Rp <?php echo e(number_format($totalCOGS, 0, ',', '.')); ?></td>
            </tr>

            <tr class="font-bold bg-success">
                <td>LABA KOTOR</td>
                <td class="text-right">Rp <?php echo e(number_format($grossProfit, 0, ',', '.')); ?></td>
            </tr>

            <tr class="font-bold <?php echo e($netProfit >= 0 ? 'bg-success' : 'bg-danger'); ?>">
                <td>LABA BERSIH</td>
                <td class="text-right">Rp <?php echo e(number_format($netProfit, 0, ',', '.')); ?></td>
            </tr>

            <tr class="font-bold">
                <td>MARGIN LABA</td>
                <td class="text-right"><?php echo e(number_format($profitMargin, 2)); ?>%</td>
            </tr>
        </tbody>
    </table>

    <p style="margin-top: 50px; font-size: 10px; text-align: right;">
        Dicetak pada: <?php echo e(date('d M Y H:i')); ?>

    </p>
</body>
</html>
<?php /**PATH C:\xampp82\htdocs\umi-cell\resources\views/report/profit-loss/pdf.blade.php ENDPATH**/ ?>