<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Faktur Penjualan</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 11px;
            margin: 15px;
        }
        .header {
            margin-bottom: 20px;
            border-bottom: 2px solid #000;
            padding-bottom: 10px;
        }
        .header table {
            width: 100%;
        }
        .header .company-info h3 {
            margin: 0;
            font-size: 14px;
            font-weight: bold;
        }
        .header .company-info p {
            margin: 2px 0;
            font-size: 9px;
        }
        .invoice-info {
            margin-bottom: 15px;
        }
        .invoice-info table {
            width: 100%;
        }
        .invoice-info td {
            padding: 3px 0;
        }
        .invoice-title {
            text-align: center;
            font-size: 16px;
            font-weight: bold;
            margin: 15px 0;
        }
        table.items {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }
        table.items thead {
            background-color: #f0f0f0;
        }
        table.items th,
        table.items td {
            border: 1px solid #000;
            padding: 6px;
        }
        table.items th {
            font-weight: bold;
            text-align: center;
        }
        .text-center {
            text-align: center;
        }
        .text-right {
            text-align: right;
        }
        .summary-table {
            width: 40%;
            margin-left: auto;
            margin-top: 15px;
        }
        .summary-table td {
            padding: 4px 8px;
        }
        .summary-table .total-row {
            font-weight: bold;
            border-top: 2px solid #000;
        }
        .footer {
            margin-top: 40px;
        }
        .footer table {
            width: 100%;
        }
        .footer .signature {
            text-align: center;
            padding-top: 50px;
        }
        .notes {
            margin-top: 20px;
            font-size: 9px;
            font-style: italic;
        }
    </style>
</head>
<body>
    <div class="header">
        <table>
            <tr>
                <td style="width: 50%;">
                    <div class="company-info">
                        <h3>UMI CELL</h3>
                        <p>Jl. Raya Semarang-Boja, Jatisari, Kec. Mijen, Kota Semarang Jawa Tengah 50275</p>
                        <p>Telp: 0882005564342</p>
                    </div>
                </td>
                <td style="width: 50%; text-align: right; vertical-align: top;">
                    <p><strong>Tanggal:</strong> <?php echo e(date('l, d F Y H:i', strtotime($sale->sale_date))); ?></p>
                    <p><strong>Pelanggan:</strong> <?php echo e($sale->customer->name ?? 'UMUM'); ?></p>
                    <p><strong>Alamat:</strong> <?php echo e($sale->branch->address ?? '-'); ?></p>
                    <p><strong>Phone:</strong></p>
                </td>
            </tr>
        </table>
    </div>

    <div class="invoice-title">
        FAKTUR PENJUALAN
    </div>

    <div class="invoice-info">
        <table>
            <tr>
                <td style="width: 15%;"><strong>Nota:</strong></td>
                <td style="width: 35%;"><?php echo e($sale->sale_number); ?></td>
                <td style="width: 15%;"><strong>Sales:</strong></td>
                <td style="width: 35%;"><?php echo e($sale->cashier->name ?? 'KASIR'); ?></td>
            </tr>
        </table>
    </div>

    <table class="items">
        <thead>
            <tr>
                <th style="width: 5%;">No</th>
                <th>Nama</th>
                <th style="width: 12%;">Qty</th>
                <th style="width: 10%;">Satuan</th>
                <th style="width: 15%;">Harga</th>
                <th style="width: 10%;">Disc1</th>
                <th style="width: 10%;">Disc2</th>
                <th style="width: 10%;">Disc3</th>
                <th style="width: 10%;">Disc4</th>
                <th style="width: 15%;">Total</th>
            </tr>
        </thead>
        <tbody>
            <?php
                $no = 1;
            ?>
            <?php $__currentLoopData = $sale->saleDetails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td class="text-center"><?php echo e($no++); ?></td>
                    <td><?php echo e($detail->product->name ?? 'N/A'); ?></td>
                    <td class="text-center"><?php echo e(number_format($detail->quantity)); ?> <?php echo e($detail->product->unit ?? 'PCS'); ?></td>
                    <td class="text-center"></td>
                    <td class="text-right"><?php echo e(number_format($detail->selling_price, 0, ',', '.')); ?></td>
                    <td class="text-center">0</td>
                    <td class="text-center">0</td>
                    <td class="text-center">0</td>
                    <td class="text-center">0</td>
                    <td class="text-right"><?php echo e(number_format($detail->subtotal, 0, ',', '.')); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <tr style="font-style: italic;">
                <td colspan="10" class="text-center">seratus sembilan ribu</td>
            </tr>
        </tbody>
    </table>

    <table class="summary-table">
        <tr>
            <td>Jumlah Item:</td>
            <td class="text-right"><?php echo e($sale->saleDetails->count()); ?></td>
            <td style="width: 30%;">Sub Total:</td>
            <td class="text-right" style="width: 35%;"><?php echo e(number_format($sale->subtotal, 0, ',', '.')); ?></td>
        </tr>
        <tr>
            <td></td>
            <td></td>
            <td>Potongan:</td>
            <td class="text-right"><?php echo e(number_format($sale->discount, 0, ',', '.')); ?></td>
        </tr>
        <tr>
            <td></td>
            <td></td>
            <td>Pajak:</td>
            <td class="text-right"><?php echo e(number_format($sale->tax, 0, ',', '.')); ?></td>
        </tr>
        <tr>
            <td></td>
            <td></td>
            <td>Total Akhir:</td>
            <td class="text-right"><?php echo e(number_format($sale->total_amount, 0, ',', '.')); ?></td>
        </tr>
        <tr>
            <td></td>
            <td></td>
            <td>DP PO:</td>
            <td class="text-right">0</td>
        </tr>
        <tr>
            <td></td>
            <td></td>
            <td>Biaya Lain:</td>
            <td class="text-right">0</td>
        </tr>
        <tr class="total-row">
            <td></td>
            <td></td>
            <td>Kredit:</td>
            <td class="text-right">0</td>
        </tr>
        <tr class="total-row">
            <td></td>
            <td></td>
            <td>K.Debet:</td>
            <td class="text-right">0</td>
        </tr>
        <tr class="total-row">
            <td></td>
            <td></td>
            <td>K.Kredit:</td>
            <td class="text-right">0</td>
        </tr>
        <tr class="total-row">
            <td></td>
            <td></td>
            <td>Kembali:</td>
            <td class="text-right">0</td>
        </tr>
    </table>

    <div class="footer">
        <table>
            <tr>
                <td style="width: 50%; text-align: center;">
                    <p>Hormat Kami</p>
                    <div class="signature">
                        _________________
                    </div>
                </td>
                <td style="width: 50%; text-align: center;">
                    <p>Penerima</p>
                    <div class="signature">
                        _________________
                    </div>
                </td>
            </tr>
        </table>
    </div>
</body>
</html>
<?php /**PATH C:\xampp82\htdocs\umi-cell\resources\views/report/sale-invoice/pdf.blade.php ENDPATH**/ ?>