<?php $__env->startSection('heading', 'Detail Pembelian'); ?>

<?php $__env->startSection('content'); ?>
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Detail Pembelian</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                    <li class="breadcrumb-item"><a href="<?php echo e(route('purchase')); ?>">Pembelian</a></li>
                    <li class="breadcrumb-item active">Detail</li>
                </ol>
            </div>
        </div>
    </div>
</section>

<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Detail Produk</h3>
                    </div>
                    <div class="card-body">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th style="width: 5%;">No</th>
                                    <th>Produk</th>
                                    <th style="width: 15%;">Qty</th>
                                    <th style="width: 20%;">Harga</th>
                                    <th style="width: 20%;">Subtotal</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $purchase->purchaseDetails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($index + 1); ?></td>
                                    <td><?php echo e($detail->product->name); ?></td>
                                    <td><?php echo e(number_format($detail->quantity, 0, ',', '.')); ?> <?php echo e($detail->product->unit); ?></td>
                                    <td class="text-right">Rp <?php echo e(number_format($detail->purchase_price, 0, ',', '.')); ?></td>
                                    <td class="text-right">Rp <?php echo e(number_format($detail->subtotal, 0, ',', '.')); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <th colspan="4" class="text-right">Total</th>
                                    <th class="text-right">Rp <?php echo e(number_format($purchase->total_amount, 0, ',', '.')); ?></th>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Informasi Pembelian</h3>
                    </div>
                    <div class="card-body">
                        <table class="table table-sm">
                            <tr>
                                <th style="width: 40%;">No. Pembelian</th>
                                <td><?php echo e($purchase->purchase_number); ?></td>
                            </tr>
                            <tr>
                                <th>Supplier</th>
                                <td><?php echo e($purchase->supplier->name); ?></td>
                            </tr>
                            <tr>
                                <th>Cabang</th>
                                <td><?php echo e($purchase->branch->name); ?></td>
                            </tr>
                            <tr>
                                <th>Tanggal</th>
                                <td><?php echo e(TanggalID($purchase->purchase_date)); ?></td>
                            </tr>
                            <tr>
                                <th>Status</th>
                                <td>
                                    <?php if($purchase->status == 'pending'): ?>
                                    <span class="badge badge-warning">Pending</span>
                                    <?php elseif($purchase->status == 'completed'): ?>
                                    <span class="badge badge-success">Selesai</span>
                                    <?php else: ?>
                                    <span class="badge badge-danger">Batal</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <th>User</th>
                                <td><?php echo e($purchase->user->name); ?></td>
                            </tr>
                            <?php if($purchase->notes): ?>
                            <tr>
                                <th>Catatan</th>
                                <td><?php echo e($purchase->notes); ?></td>
                            </tr>
                            <?php endif; ?>
                            <tr>
                                <th>Dibuat</th>
                                <td><?php echo e(TanggalID($purchase->created_at)); ?></td>
                            </tr>
                        </table>
                    </div>
                    <div class="card-footer">
                        <a href="<?php echo e(route('purchase')); ?>" class="btn btn-secondary btn-block">
                            <i class="fas fa-arrow-left"></i> Kembali
                        </a>
                        <a href="<?php echo e(route('purchase.invoice-pdf', $purchase->id)); ?>" class="btn btn-success btn-block" target="_blank">
                            <i class="fas fa-print"></i> Cetak Faktur
                        </a>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('purchases.edit')): ?>
                        <?php if($purchase->status == 'pending'): ?>
                        <a href="<?php echo e(route('purchase.edit', $purchase->id)); ?>" class="btn btn-primary btn-block">
                            <i class="fas fa-edit"></i> Edit
                        </a>
                        <?php endif; ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp82\htdocs\umi-cell\resources\views/transaction/purchase/show.blade.php ENDPATH**/ ?>