<?php $__env->startSection('heading', 'Laporan Daftar Item'); ?>

<?php $__env->startSection('content'); ?>
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Laporan Daftar Item</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                    <li class="breadcrumb-item active">Laporan Daftar Item</li>
                </ol>
            </div>
        </div>
    </div>
</section>

<section class="content">
    <div class="container-fluid">
        <!-- Filter Card -->
        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><i class="fas fa-filter"></i> Filter Laporan</h3>
                <div class="card-tools">
                    <a href="<?php echo e(route('report.product-list.export-pdf', ['branch_id' => $branchId])); ?>" class="btn btn-danger btn-sm" target="_blank">
                        <i class="fas fa-file-pdf"></i> Export PDF
                    </a>
                </div>
            </div>
            <div class="card-body">
                <form action="<?php echo e(route('report.product-list')); ?>" method="GET">
                    <div class="row">
                        <div class="col-md-10">
                            <div class="form-group">
                                <label>Cabang</label>
                                <select name="branch_id" class="form-control">
                                    <option value="">Semua Cabang</option>
                                    <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($branch->id); ?>" <?php echo e($branchId == $branch->id ? 'selected' : ''); ?>>
                                            <?php echo e($branch->name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>&nbsp;</label>
                                <button type="submit" class="btn btn-primary btn-block">
                                    <i class="fas fa-search"></i> Filter
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <!-- Products Table -->
        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><i class="fas fa-boxes"></i> Daftar Item</h3>
            </div>
            <div class="card-body">
                <table class="table table-bordered table-striped table-sm" id="productTable">
                    <thead>
                        <tr>
                            <th>Kode</th>
                            <th>Nama Produk</th>
                            <th>Kategori</th>
                            <th>Merek</th>
                            <th>Total Stok</th>
                            <th>Stok Min</th>
                            <th>Harga Beli</th>
                            <th>Harga Jual</th>
                            <th>Deskripsi</th>
                            <th>Aset (h.Beli*Qty)</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                            $totalAsset = 0;
                        ?>
                        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $totalAsset += $product->asset;
                            ?>
                            <tr>
                                <td class="text-center">B-<?php echo e(str_pad($product->id, 4, '0', STR_PAD_LEFT)); ?></td>
                                <td><?php echo e($product->name); ?></td>
                                <td><?php echo e($product->category->name ?? '-'); ?></td>
                                <td><?php echo e($product->brand->name ?? '-'); ?></td>
                                <td class="text-center"><?php echo e(number_format($product->stock_quantity)); ?> <?php echo e($product->unit); ?></td>
                                <td class="text-center"><?php echo e($product->min_stock ?? 0); ?></td>
                                <td class="text-right">Rp <?php echo e(number_format($product->purchase_price, 0, ',', '.')); ?></td>
                                <td class="text-right">Rp <?php echo e(number_format($product->selling_price, 0, ',', '.')); ?></td>
                                <td><?php echo e($product->description ?? '-'); ?></td>
                                <td class="text-right">Rp <?php echo e(number_format($product->asset, 0, ',', '.')); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                    <tfoot>
                        <tr class="font-weight-bold bg-light">
                            <td colspan="9" class="text-right">TOTAL ASET:</td>
                            <td class="text-right">Rp <?php echo e(number_format($totalAsset, 0, ',', '.')); ?></td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
$(function() {
    $('#productTable').DataTable({
        "paging": true,
        "lengthChange": true,
        "searching": true,
        "ordering": true,
        "info": true,
        "autoWidth": false,
        "responsive": true,
    });
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp82\htdocs\umi-cell\resources\views/report/product-list/index.blade.php ENDPATH**/ ?>