<?php $__env->startSection('heading', 'Service'); ?>

<?php $__env->startSection('content'); ?>
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Data Service</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                    <li class="breadcrumb-item active">Service</li>
                </ol>
            </div>
        </div>
    </div>
</section>

<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Daftar Service</h3>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('services.create')): ?>
                        <div class="card-tools">
                            <a href="<?php echo e(route('services.create')); ?>" class="btn btn-success btn-sm">
                                <i class="fas fa-plus"></i> Tambah Service
                            </a>
                        </div>
                        <?php endif; ?>
                    </div>
                    <div class="card-body">
                        <?php if(session('success')): ?>
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <?php echo e(session('success')); ?>

                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <?php endif; ?>

                        <?php if(session('error')): ?>
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <?php echo e(session('error')); ?>

                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <?php endif; ?>

                        <table id="example1" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th style="width: 5%;">No</th>
                                    <th>No. Service</th>
                                    <th>Tanggal</th>
                                    <th>Customer</th>
                                    <th>Perangkat</th>
                                    <th>Keluhan</th>
                                    <th>Status</th>
                                    <th>Teknisi</th>
                                    <th>Total Biaya</th>
                                    <th style="width: 15%;">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($index + 1); ?></td>
                                    <td><?php echo e($service->service_number); ?></td>
                                    <td><?php echo e(TanggalID($service->service_date)); ?></td>
                                    <td><?php echo e($service->customer->name); ?></td>
                                    <td>
                                        <strong><?php echo e($service->device_brand); ?> <?php echo e($service->device_model); ?></strong><br>
                                        <small class="text-muted"><?php echo e($service->device_type); ?></small>
                                    </td>
                                    <td><?php echo e(Str::limit($service->complaint, 30)); ?></td>
                                    <td>
                                        <?php if($service->status == 'menunggu diagnosa'): ?>
                                        <span class="badge badge-secondary">Menunggu Diagnosa</span>
                                        <?php elseif($service->status == 'sedang diagnosa'): ?>
                                        <span class="badge badge-primary">Sedang Diagnosa</span>
                                        <?php elseif($service->status == 'menunggu persetujuan'): ?>
                                        <span class="badge badge-warning">Menunggu Persetujuan</span>
                                        <?php elseif($service->status == 'menunggu spare part'): ?>
                                        <span class="badge badge-warning">Menunggu Spare Part</span>
                                        <?php elseif($service->status == 'dalam pengerjaan'): ?>
                                        <span class="badge badge-info">Dalam Pengerjaan</span>
                                        <?php elseif($service->status == 'quality control'): ?>
                                        <span class="badge badge-purple">Quality Control</span>
                                        <?php elseif($service->status == 'siap diambil'): ?>
                                        <span class="badge badge-success">Siap Diambil</span>
                                        <?php elseif($service->status == 'selesai'): ?>
                                        <span class="badge badge-dark">Selesai</span>
                                        <?php else: ?>
                                        <span class="badge badge-danger">Dibatalkan</span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($service->technician ? $service->technician->name : '-'); ?></td>
                                    <td class="text-right">Rp <?php echo e(number_format($service->total_cost, 0, ',', '.')); ?></td>
                                    <td>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('services.index')): ?>
                                        <a href="<?php echo e(route('services.show', $service->id)); ?>" class="btn btn-info btn-sm" title="Detail">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <?php endif; ?>

                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('services.edit')): ?>
                                        <a href="<?php echo e(route('services.edit', $service->id)); ?>" class="btn btn-warning btn-sm" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <?php endif; ?>

                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('services.delete')): ?>
                                        <form action="<?php echo e(route('services.destroy', $service->id)); ?>" method="POST" class="d-inline delete-form-<?php echo e($service->id); ?>">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="button" class="btn btn-danger btn-sm delete" title="Hapus" data-id="<?php echo e($service->id); ?>" data-name="<?php echo e($service->service_number); ?>">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<!-- DataTable sudah dihandle di layouts/script.blade.php -->
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp82\htdocs\umi-cell\resources\views/transaction/service/index.blade.php ENDPATH**/ ?>