<?php $__env->startSection('heading', 'Pembelian'); ?>

<?php $__env->startSection('content'); ?>
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Data Pembelian</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                    <li class="breadcrumb-item active">Pembelian</li>
                </ol>
            </div>
        </div>
    </div>
</section>

<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Daftar Pembelian</h3>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('purchases.create')): ?>
                        <div class="card-tools">
                            <a href="<?php echo e(route('purchase.create')); ?>" class="btn btn-success btn-sm">
                                <i class="fas fa-plus"></i> Tambah Pembelian
                            </a>
                        </div>
                        <?php endif; ?>
                    </div>
                    <div class="card-body">
                        <?php if(session('success')): ?>
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <?php echo e(session('success')); ?>

                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <?php endif; ?>

                        <?php if(session('error')): ?>
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <?php echo e(session('error')); ?>

                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <?php endif; ?>

                        <table id="example1" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th style="width: 5%;">No</th>
                                    <th>No. Pembelian</th>
                                    <th>Tanggal</th>
                                    <th>Supplier</th>
                                    <th>Cabang</th>
                                    <th>Total</th>
                                    <th>Status</th>
                                    <th>User</th>
                                    <th style="width: 15%;">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $purchases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $purchase): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($index + 1); ?></td>
                                    <td><?php echo e($purchase->purchase_number); ?></td>
                                    <td><?php echo e(TanggalID($purchase->purchase_date)); ?></td>
                                    <td><?php echo e($purchase->supplier->name); ?></td>
                                    <td><?php echo e($purchase->branch->name); ?></td>
                                    <td class="text-right">Rp <?php echo e(number_format($purchase->total_amount, 0, ',', '.')); ?></td>
                                    <td>
                                        <?php if($purchase->status == 'pending'): ?>
                                        <span class="badge badge-warning">Pending</span>
                                        <?php elseif($purchase->status == 'completed'): ?>
                                        <span class="badge badge-success">Selesai</span>
                                        <?php else: ?>
                                        <span class="badge badge-danger">Batal</span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($purchase->user->name); ?></td>
                                    <td>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('purchases.index')): ?>
                                        <a href="<?php echo e(route('purchase.show', $purchase->id)); ?>" class="btn btn-info btn-sm" title="Detail">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <?php endif; ?>

                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('purchases.edit')): ?>
                                        
                                        <a href="<?php echo e(route('purchase.edit', $purchase->id)); ?>" class="btn btn-primary btn-sm" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        
                                        <?php endif; ?>

                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('purchases.delete')): ?>
                                        
                                        <form action="<?php echo e(route('purchase.delete', $purchase->id)); ?>" method="POST" style="display:inline;" class="delete-form-<?php echo e($purchase->id); ?>">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="button" class="btn btn-danger btn-sm delete" data-id="<?php echo e($purchase->id); ?>" data-name="Pembelian <?php echo e($purchase->purchase_number); ?>" title="Hapus">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                        
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp82\htdocs\umi-cell\resources\views/transaction/purchase/index.blade.php ENDPATH**/ ?>