@section('heading', 'Service')
@extends('layouts.app')
@section('content')
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Data Service</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{route('home')}}">Home</a></li>
                    <li class="breadcrumb-item active">Service</li>
                </ol>
            </div>
        </div>
    </div>
</section>

<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Daftar Service</h3>
                        @can('services.create')
                        <div class="card-tools">
                            <a href="{{route('services.create')}}" class="btn btn-success btn-sm">
                                <i class="fas fa-plus"></i> Tambah Service
                            </a>
                        </div>
                        @endcan
                    </div>
                    <div class="card-body">
                        @if(session('success'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            {{ session('success') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        @endif

                        @if(session('error'))
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            {{ session('error') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        @endif

                        <table id="example1" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th style="width: 5%;">No</th>
                                    <th>No. Service</th>
                                    <th>Tanggal</th>
                                    <th>Customer</th>
                                    <th>Perangkat</th>
                                    <th>Keluhan</th>
                                    <th>Status</th>
                                    <th>Teknisi</th>
                                    <th>Total Biaya</th>
                                    <th style="width: 15%;">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($services as $index => $service)
                                <tr>
                                    <td>{{$index + 1}}</td>
                                    <td>{{$service->service_number}}</td>
                                    <td>{{TanggalID($service->service_date)}}</td>
                                    <td>{{$service->customer->name}}</td>
                                    <td>
                                        <strong>{{$service->device_brand}} {{$service->device_model}}</strong><br>
                                        <small class="text-muted">{{$service->device_type}}</small>
                                    </td>
                                    <td>{{Str::limit($service->complaint, 30)}}</td>
                                    <td>
                                        @if($service->status == 'menunggu diagnosa')
                                        <span class="badge badge-secondary">Menunggu Diagnosa</span>
                                        @elseif($service->status == 'sedang diagnosa')
                                        <span class="badge badge-primary">Sedang Diagnosa</span>
                                        @elseif($service->status == 'menunggu persetujuan')
                                        <span class="badge badge-warning">Menunggu Persetujuan</span>
                                        @elseif($service->status == 'menunggu spare part')
                                        <span class="badge badge-warning">Menunggu Spare Part</span>
                                        @elseif($service->status == 'dalam pengerjaan')
                                        <span class="badge badge-info">Dalam Pengerjaan</span>
                                        @elseif($service->status == 'quality control')
                                        <span class="badge badge-purple">Quality Control</span>
                                        @elseif($service->status == 'siap diambil')
                                        <span class="badge badge-success">Siap Diambil</span>
                                        @elseif($service->status == 'selesai')
                                        <span class="badge badge-dark">Selesai</span>
                                        @else
                                        <span class="badge badge-danger">Dibatalkan</span>
                                        @endif
                                    </td>
                                    <td>{{$service->technician ? $service->technician->name : '-'}}</td>
                                    <td class="text-right">Rp {{number_format($service->total_cost, 0, ',', '.')}}</td>
                                    <td>
                                        @can('services.index')
                                        <a href="{{route('services.show', $service->id)}}" class="btn btn-info btn-sm" title="Detail">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        @endcan

                                        @can('services.edit')
                                        <a href="{{route('services.edit', $service->id)}}" class="btn btn-warning btn-sm" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        @endcan

                                        @can('services.delete')
                                        <form action="{{route('services.destroy', $service->id)}}" method="POST" class="d-inline delete-form-{{$service->id}}">
                                            @csrf
                                            @method('DELETE')
                                            <button type="button" class="btn btn-danger btn-sm delete" title="Hapus" data-id="{{$service->id}}" data-name="{{$service->service_number}}">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                        @endcan
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection

@push('scripts')
<!-- DataTable sudah dihandle di layouts/script.blade.php -->
@endpush
