@section('heading', 'Penjualan')
@extends('layouts.app')
@section('content')
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Data Penjualan</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{route('home')}}">Home</a></li>
                    <li class="breadcrumb-item active">Penjualan</li>
                </ol>
            </div>
        </div>
    </div>
</section>

<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Daftar Penjualan</h3>
                        @can('sales.create')
                        <div class="card-tools">
                            <a href="{{route('sale.create')}}" class="btn btn-success btn-sm">
                                <i class="fas fa-plus"></i> Tambah Penjualan
                            </a>
                        </div>
                        @endcan
                    </div>
                    <div class="card-body">
                        @if(session('success'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            {{ session('success') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        @endif

                        @if(session('error'))
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            {{ session('error') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        @endif

                        <table id="example1" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th style="width: 5%;">No</th>
                                    <th>No. Penjualan</th>
                                    <th>Tanggal</th>
                                    <th>Customer</th>
                                    <th>Cabang</th>
                                    <th>Total</th>
                                    <th>Metode Bayar</th>
                                    <th>Status</th>
                                    <th>Kasir</th>
                                    <th style="width: 15%;">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($sales as $index => $sale)
                                <tr>
                                    <td>{{$index + 1}}</td>
                                    <td>{{$sale->sale_number}}</td>
                                    <td>{{TanggalID($sale->sale_date)}}</td>
                                    <td>{{$sale->customer ? $sale->customer->name : 'Umum'}}</td>
                                    <td>{{$sale->branch->name}}</td>
                                    <td class="text-right">Rp {{number_format($sale->total_amount, 0, ',', '.')}}</td>
                                    <td>
                                        @if($sale->payment_method == 'cash')
                                        <span class="badge badge-success">Tunai</span>
                                        @elseif($sale->payment_method == 'transfer')
                                        <span class="badge badge-info">Transfer</span>
                                        @else
                                        <span class="badge badge-warning">Kredit</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($sale->status == 'pending')
                                        <span class="badge badge-warning">Pending</span>
                                        @elseif($sale->status == 'completed')
                                        <span class="badge badge-success">Selesai</span>
                                        @else
                                        <span class="badge badge-danger">Batal</span>
                                        @endif
                                    </td>
                                    <td>{{$sale->cashier->name}}</td>
                                    <td>
                                        @can('sales.index')
                                        <a href="{{route('sale.show', $sale->id)}}" class="btn btn-info btn-sm" title="Detail">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        @endcan

                                        @can('sales.edit')
                                        {{-- @if($sale->status == 'pending') --}}
                                        <a href="{{route('sale.edit', $sale->id)}}" class="btn btn-primary btn-sm" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        {{-- @endif --}}
                                        @endcan

                                        @can('sales.delete')
                                        {{-- @if($sale->status == 'pending') --}}
                                        <form action="{{ route('sale.delete', $sale->id) }}" method="POST" style="display:inline;" class="delete-form-{{ $sale->id }}">
                                            @csrf
                                            @method('DELETE')
                                            <button type="button" class="btn btn-danger btn-sm delete" data-id="{{ $sale->id }}" data-name="Penjualan {{ $sale->sale_number }}" title="Hapus">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                        {{-- @endif --}}
                                        @endcan
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection
