@section('heading', 'Pembelian')
@extends('layouts.app')
@section('content')
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Data Pembelian</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{route('home')}}">Home</a></li>
                    <li class="breadcrumb-item active">Pembelian</li>
                </ol>
            </div>
        </div>
    </div>
</section>

<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Daftar Pembelian</h3>
                        @can('purchases.create')
                        <div class="card-tools">
                            <a href="{{route('purchase.create')}}" class="btn btn-success btn-sm">
                                <i class="fas fa-plus"></i> Tambah Pembelian
                            </a>
                        </div>
                        @endcan
                    </div>
                    <div class="card-body">
                        @if(session('success'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            {{ session('success') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        @endif

                        @if(session('error'))
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            {{ session('error') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        @endif

                        <table id="example1" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th style="width: 5%;">No</th>
                                    <th>No. Pembelian</th>
                                    <th>Tanggal</th>
                                    <th>Supplier</th>
                                    <th>Cabang</th>
                                    <th>Total</th>
                                    <th>Status</th>
                                    <th>User</th>
                                    <th style="width: 15%;">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($purchases as $index => $purchase)
                                <tr>
                                    <td>{{$index + 1}}</td>
                                    <td>{{$purchase->purchase_number}}</td>
                                    <td>{{TanggalID($purchase->purchase_date)}}</td>
                                    <td>{{$purchase->supplier->name}}</td>
                                    <td>{{$purchase->branch->name}}</td>
                                    <td class="text-right">Rp {{number_format($purchase->total_amount, 0, ',', '.')}}</td>
                                    <td>
                                        @if($purchase->status == 'pending')
                                        <span class="badge badge-warning">Pending</span>
                                        @elseif($purchase->status == 'completed')
                                        <span class="badge badge-success">Selesai</span>
                                        @else
                                        <span class="badge badge-danger">Batal</span>
                                        @endif
                                    </td>
                                    <td>{{$purchase->user->name}}</td>
                                    <td>
                                        @can('purchases.index')
                                        <a href="{{route('purchase.show', $purchase->id)}}" class="btn btn-info btn-sm" title="Detail">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        @endcan

                                        @can('purchases.edit')
                                        {{-- @if($purchase->status == 'pending') --}}
                                        <a href="{{route('purchase.edit', $purchase->id)}}" class="btn btn-primary btn-sm" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        {{-- @endif --}}
                                        @endcan

                                        @can('purchases.delete')
                                        {{-- @if($purchase->status == 'pending') --}}
                                        <form action="{{ route('purchase.delete', $purchase->id) }}" method="POST" style="display:inline;" class="delete-form-{{ $purchase->id }}">
                                            @csrf
                                            @method('DELETE')
                                            <button type="button" class="btn btn-danger btn-sm delete" data-id="{{ $purchase->id }}" data-name="Pembelian {{ $purchase->purchase_number }}" title="Hapus">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                        {{-- @endif --}}
                                        @endcan
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection
