<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class ServiceReportPermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create permission
        Permission::create(['name' => 'service-reports.index']);

        // Assign permission to admin role
        $admin = Role::findByName('admin');
        $admin->givePermissionTo('service-reports.index');
    }
}
