<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class CustomerSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $customers = [
            [
                'name' => 'Budi Santoso',
                'phone' => '081234567890',
                'address' => 'Jl. Mawar No. 10, Jakarta',
                'email' => 'budi@example.com',
            ],
            [
                'name' => 'Siti Nurhaliza',
                'phone' => '082345678901',
                'address' => 'Jl. Melati No. 20, Bekasi',
                'email' => 'siti@example.com',
            ],
        ];

        foreach ($customers as $customer) {
            \App\Models\Customer::create($customer);
        }
    }
}
