@section('heading', 'Service')
@extends('layouts.app')
@section('content')
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Data Service</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{route('home')}}">Home</a></li>
                    <li class="breadcrumb-item active">Service</li>
                </ol>
            </div>
        </div>
    </div>
</section>

<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Daftar Service</h3>
                        @can('services.create')
                        <div class="card-tools">
                            <button type="button" class="btn btn-primary btn-sm mr-1" data-toggle="modal" data-target="#scanQrCodeModal">
                                <i class="fas fa-qrcode"></i> Scan QR Code
                            </button>
                            <a href="{{route('services.create')}}" class="btn btn-success btn-sm">
                                <i class="fas fa-plus"></i> Tambah Service
                            </a>
                        </div>
                        @endcan
                    </div>
                    <div class="card-body">
                        @if(session('success'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            {{ session('success') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        @endif

                        @if(session('error'))
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            {{ session('error') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        @endif

                        <table id="example1" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th style="width: 5%;">No</th>
                                    <th>No. Service</th>
                                    <th>Tanggal</th>
                                    <th>Customer</th>
                                    <th>Perangkat</th>
                                    <th>Keluhan</th>
                                    <th>Status</th>
                                    <th>Teknisi</th>
                                    <th>Total Biaya</th>
                                    <th style="width: 15%;">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($services as $index => $service)
                                <tr>
                                    <td>{{$index + 1}}</td>
                                    <td>{{$service->service_number}}</td>
                                    <td>{{TanggalID($service->service_date)}}</td>
                                    <td>{{$service->customer->name}}</td>
                                    <td>
                                        <strong>{{$service->device_brand}} {{$service->device_model}}</strong><br>
                                        <small class="text-muted">{{$service->device_type}}</small>
                                    </td>
                                    <td>{{Str::limit($service->complaint, 30)}}</td>
                                    <td>
                                        @if($service->status == 'menunggu diagnosa')
                                        <span class="badge badge-secondary">Menunggu Diagnosa</span>
                                        @elseif($service->status == 'sedang diagnosa')
                                        <span class="badge badge-primary">Sedang Diagnosa</span>
                                        @elseif($service->status == 'menunggu persetujuan')
                                        <span class="badge badge-warning">Menunggu Persetujuan</span>
                                        @elseif($service->status == 'menunggu spare part')
                                        <span class="badge badge-warning">Menunggu Spare Part</span>
                                        @elseif($service->status == 'dalam pengerjaan')
                                        <span class="badge badge-info">Dalam Pengerjaan</span>
                                        @elseif($service->status == 'quality control')
                                        <span class="badge badge-purple">Quality Control</span>
                                        @elseif($service->status == 'siap diambil')
                                        <span class="badge badge-success">Siap Diambil</span>
                                        @elseif($service->status == 'selesai')
                                        <span class="badge badge-dark">Selesai</span>
                                        @else
                                        <span class="badge badge-danger">Dibatalkan</span>
                                        @endif
                                    </td>
                                    <td>{{$service->technician ? $service->technician->name : '-'}}</td>
                                    <td class="text-right">Rp {{number_format($service->total_cost, 0, ',', '.')}}</td>
                                    <td>
                                        @can('services.index')
                                        <a href="{{route('services.show', $service->id)}}" class="btn btn-info btn-sm" title="Detail">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        @endcan

                                        @can('services.edit')
                                        <a href="{{route('services.edit', $service->id)}}" class="btn btn-warning btn-sm" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        @endcan

                                        @can('services.delete')
                                        <form action="{{route('services.destroy', $service->id)}}" method="POST" class="d-inline delete-form-{{$service->id}}">
                                            @csrf
                                            @method('DELETE')
                                            <button type="button" class="btn btn-danger btn-sm delete" title="Hapus" data-id="{{$service->id}}" data-name="{{$service->service_number}}">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                        @endcan
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Modal Scan QR Code -->
<div class="modal fade" id="scanQrCodeModal" tabindex="-1" role="dialog" aria-labelledby="scanQrModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="scanQrModalLabel">
                    <i class="fas fa-qrcode"></i> Scan QR Code Service
                </h5>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <!-- Tab Navigation -->
                <ul class="nav nav-tabs mb-3" id="scanTab" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" id="manual-scan-tab" data-toggle="tab" href="#manualScan" role="tab">
                            <i class="fas fa-keyboard"></i> Input Manual
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="camera-scan-tab" data-toggle="tab" href="#cameraScan" role="tab">
                            <i class="fas fa-camera"></i> Scan dengan Kamera
                        </a>
                    </li>
                </ul>

                <!-- Tab Content -->
                <div class="tab-content" id="scanTabContent">
                    <!-- Manual Input Tab -->
                    <div class="tab-pane fade show active" id="manualScan" role="tabpanel">
                        <div class="form-group">
                            <label><i class="fas fa-qrcode"></i> Scan atau Ketik QR Code Service</label>
                            <input type="text" id="barcodeInputIndex" class="form-control form-control-lg"
                                placeholder="Scan QR Code atau ketik QR Code service..." autofocus>
                            <small class="form-text text-muted">
                                <i class="fas fa-info-circle"></i> Gunakan QR Code scanner atau ketik QR Code service, tekan Enter untuk mencari
                            </small>
                        </div>
                    </div>

                    <!-- Camera Scan Tab -->
                    <div class="tab-pane fade" id="cameraScan" role="tabpanel">
                        <div class="text-center mb-3">
                            <button type="button" id="startCameraBtnIndex" class="btn btn-success btn-lg">
                                <i class="fas fa-camera"></i> Aktifkan Kamera untuk Scan QR Code
                            </button>
                            <button type="button" id="stopCameraBtnIndex" class="btn btn-danger btn-lg" style="display: none;">
                                <i class="fas fa-stop"></i> Matikan Kamera
                            </button>
                        </div>
                        <div id="qr-reader-index" style="display: none; width: 100%; max-width: 600px; margin: 0 auto;"></div>
                        <div id="qr-reader-results-index" class="mt-2"></div>
                    </div>
                </div>

                <!-- Service Result -->
                <div id="serviceResult" class="mt-3" style="display: none;">
                    <div class="alert alert-success">
                        <h5><i class="fas fa-check-circle"></i> Service Ditemukan!</h5>
                        <div id="serviceInfo"></div>
                        <div class="mt-3">
                            <a href="#" id="goToDetailBtn" class="btn btn-primary">
                                <i class="fas fa-eye"></i> Lihat Detail Service
                            </a>
                        </div>
                    </div>
                </div>

                <!-- Not Found Result -->
                <div id="notFoundResult" class="mt-3" style="display: none;">
                    <div class="alert alert-danger">
                        <h5><i class="fas fa-times-circle"></i> Service Tidak Ditemukan</h5>
                        <p class="mb-0">QR Code yang di-scan tidak terdaftar di sistem.</p>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">
                    <i class="fas fa-times"></i> Tutup
                </button>
            </div>
        </div>
    </div>
</div>

@endsection

@push('scripts')
<!-- HTML5 QR Code Scanner Library -->
<script src="https://unpkg.com/html5-qrcode@2.3.8/html5-qrcode.min.js"></script>

<script>
let html5QrCodeIndex = null;

$(function() {
    // Reset modal when opened
    $('#scanQrCodeModal').on('shown.bs.modal', function () {
        $('#barcodeInputIndex').focus();
        $('#serviceResult').hide();
        $('#notFoundResult').hide();
        $('#barcodeInputIndex').val('');
    });

    // Reset camera when modal closed
    $('#scanQrCodeModal').on('hidden.bs.modal', function () {
        stopQrScannerIndex();
        $('#serviceResult').hide();
        $('#notFoundResult').hide();
        $('#barcodeInputIndex').val('');
    });

    // Manual barcode input handler
    $('#barcodeInputIndex').on('keypress', function(e) {
        if (e.which === 13) { // Enter key pressed
            e.preventDefault();
            const barcode = $(this).val().trim();

            if (!barcode) {
                alert('Masukkan QR Code service!');
                return;
            }

            // Find service by barcode
            findServiceByBarcodeIndex(barcode);
        }
    });

    // Auto focus to barcode input when manual tab is active
    $('#manual-scan-tab').on('click', function() {
        setTimeout(function() {
            $('#barcodeInputIndex').focus();
        }, 100);
    });

    // Start camera button
    $('#startCameraBtnIndex').on('click', function() {
        startQrScannerIndex();
    });

    // Stop camera button
    $('#stopCameraBtnIndex').on('click', function() {
        stopQrScannerIndex();
    });

    // When leaving camera tab, stop camera
    $('#manual-scan-tab').on('click', function() {
        stopQrScannerIndex();
    });
});

function startQrScannerIndex() {
    // Show camera preview
    $('#qr-reader-index').show();
    $('#startCameraBtnIndex').hide();
    $('#stopCameraBtnIndex').show();

    // Initialize QR Code scanner
    html5QrCodeIndex = new Html5Qrcode("qr-reader-index");

    const config = {
        fps: 10,
        qrbox: { width: 250, height: 250 }
    };

    html5QrCodeIndex.start(
        { facingMode: "environment" }, // Use back camera
        config,
        (decodedText, decodedResult) => {
            // QR Code successfully scanned
            console.log(`QR Code detected: ${decodedText}`);

            // Process the scanned barcode
            findServiceByBarcodeIndex(decodedText);

            // Stop scanner after successful scan
            stopQrScannerIndex();
        },
        (errorMessage) => {
            // Scan error (can be ignored, happens during scanning)
        }
    ).catch((err) => {
        console.error('Error starting QR scanner:', err);
        alert('Gagal mengaktifkan kamera. Pastikan Anda memberikan izin akses kamera.');
        stopQrScannerIndex();
    });
}

function stopQrScannerIndex() {
    if (html5QrCodeIndex) {
        html5QrCodeIndex.stop().then(() => {
            html5QrCodeIndex.clear();
            html5QrCodeIndex = null;
            $('#qr-reader-index').hide();
            $('#startCameraBtnIndex').show();
            $('#stopCameraBtnIndex').hide();
        }).catch((err) => {
            console.error('Error stopping QR scanner:', err);
            $('#qr-reader-index').hide();
            $('#startCameraBtnIndex').show();
            $('#stopCameraBtnIndex').hide();
        });
    } else {
        $('#qr-reader-index').hide();
        $('#startCameraBtnIndex').show();
        $('#stopCameraBtnIndex').hide();
    }
}

function findServiceByBarcodeIndex(barcode) {
    // Show loading
    $('#serviceResult').hide();
    $('#notFoundResult').hide();

    $.ajax({
        url: '{{ route("service.find-service-by-barcode") }}',
        method: 'GET',
        data: { barcode: barcode },
        success: function(response) {
            if (response.success && response.service) {
                const service = response.service;

                // Display service info
                const serviceHtml = `
                    <table class="table table-sm table-bordered">
                        <tr>
                            <th style="width: 30%;">No. Service</th>
                            <td><strong>${service.service_number}</strong></td>
                        </tr>
                        <tr>
                            <th>QR Code</th>
                            <td><code>${service.barcode}</code></td>
                        </tr>
                        <tr>
                            <th>Customer</th>
                            <td>${service.customer_name}</td>
                        </tr>
                        <tr>
                            <th>Cabang</th>
                            <td>${service.branch_name}</td>
                        </tr>
                        <tr>
                            <th>Teknisi</th>
                            <td>${service.technician_name}</td>
                        </tr>
                        <tr>
                            <th>Perangkat</th>
                            <td><strong>${service.device_brand} ${service.device_model}</strong><br><small>${service.device_type}</small></td>
                        </tr>
                        <tr>
                            <th>Tanggal Service</th>
                            <td>${service.service_date}</td>
                        </tr>
                        <tr>
                            <th>Total Biaya</th>
                            <td><strong>Rp ${service.total_cost}</strong></td>
                        </tr>
                        <tr>
                            <th>Status</th>
                            <td><span class="badge badge-info">${service.status.toUpperCase()}</span></td>
                        </tr>
                    </table>
                `;

                $('#serviceInfo').html(serviceHtml);
                $('#serviceResult').show();

                // Set link to detail page
                $('#goToDetailBtn').attr('href', service.url);

            } else {
                $('#notFoundResult').show();
            }
        },
        error: function(xhr) {
            $('#notFoundResult').show();
            console.error('Error finding service:', xhr);
        }
    });
}
</script>
@endpush
