<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class SupplierSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $suppliers = [
            [
                'name' => 'PT Distributor Handphone Jaya',
                'phone' => '021-11111111',
                'address' => 'Jl. Mangga Dua, Jakarta',
                'email' => 'supplier1@example.com',
            ],
            [
                'name' => 'CV Aksesoris Mobile',
                'phone' => '021-22222222',
                'address' => 'Jl. ITC Cempaka Mas, Jakarta',
                'email' => 'supplier2@example.com',
            ],
        ];

        foreach ($suppliers as $supplier) {
            \App\Models\Supplier::create($supplier);
        }
    }
}
