<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ServiceStatusHistory extends Model
{
    protected $fillable = [
        'service_id',
        'status',
        'notes',
        'user_id',
    ];

    // Relasi ke Service
    public function service()
    {
        return $this->belongsTo(Service::class);
    }

    // Relasi ke User (yang ubah status)
    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
