<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use App\Models\User;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    //protected $redirectTo = '/home';
    //protected $redirectTo = '/admin/home';

    /**
     * Get the post-login redirect path based on user role.
     *
     * @return string
     */
    protected function redirectTo()
    {
        // Check if user has customer role
        if (auth()->user()->hasRole('customer')) {
            return '/customer/dashboard';
        }

        // Default redirect for other users (admin, staff, etc)
        return '/admin/home';
    }

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
        $this->middleware('auth')->only('logout');
    }

    /**
     * Handle a login request to the application.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Http\Response|\Illuminate\Http\JsonResponse
     */
    public function login(Request $request)
    {
        $this->validateLogin($request);

        // Get the email from request
        $email = $request->input('email');

        // Check if email exists
        $userExists = User::where('email', $email)->first();

        if (!$userExists) {
            // Email tidak ditemukan
            return back()->withErrors([
                'email' => 'Email tidak terdaftar di sistem.',
            ])->withInput($request->only('email'));
        }

        // Email exists, now try to authenticate
        if ($this->attemptLogin($request)) {
            return $this->sendLoginResponse($request);
        }

        // Email exists but password is wrong
        return back()->withErrors([
            'password' => 'Password yang Anda masukkan salah.',
        ])->withInput($request->only('email'));
    }
}
