<?php

if (! function_exists('setActive')) {

    /**
     * setActive
     *
     * @param  mixed $path
     * @return void
     */
    function setActive($path)
    {
        return Request::is($path . '*') ? ' active' :  '';
    }

}

if (! function_exists('TanggalID')) {

    /**
     * TanggalID
     *
     * @param  mixed $tanggal
     * @return void
     */
    function TanggalID($tanggal) {
        $value = Carbon\Carbon::parse($tanggal);
        $parse = $value->locale('id');
        return $parse->translatedFormat('l, d F Y');
    }
}

if (! function_exists('generateQrCode')) {

    /**
     * Generate QR Code SVG
     *
     * @param  string $data
     * @param  int $size
     * @return string
     */
    function generateQrCode($data, $size = 100)
    {
        $renderer = new \BaconQrCode\Renderer\ImageRenderer(
            new \BaconQrCode\Renderer\RendererStyle\RendererStyle($size),
            new \BaconQrCode\Renderer\Image\SvgImageBackEnd()
        );

        $writer = new \BaconQrCode\Writer($renderer);
        return $writer->writeString($data);
    }
}

if (! function_exists('generateQrCodeBase64')) {

    /**
     * Generate QR Code as PNG Base64 for PDF
     *
     * @param  string $data
     * @param  int $size
     * @return string
     */
    function generateQrCodeBase64($data, $size = 100)
    {
        // Generate QR code matrix
        $qrCode = \BaconQrCode\Encoder\Encoder::encode(
            $data,
            \BaconQrCode\Common\ErrorCorrectionLevel::L(),
            'UTF-8'
        );
        $matrix = $qrCode->getMatrix();

        $moduleSize = 10;
        $quietZone = 2;
        $matrixWidth = $matrix->getWidth();

        $imageWidth = ($matrixWidth + ($quietZone * 2)) * $moduleSize;

        // Create image
        $img = imagecreatetruecolor($imageWidth, $imageWidth);
        $white = imagecolorallocate($img, 255, 255, 255);
        $black = imagecolorallocate($img, 0, 0, 0);

        // Fill white background
        imagefill($img, 0, 0, $white);

        // Draw QR code modules
        for ($y = 0; $y < $matrixWidth; $y++) {
            for ($x = 0; $x < $matrixWidth; $x++) {
                if ($matrix->get($x, $y) === 1) {
                    $xPos = ($x + $quietZone) * $moduleSize;
                    $yPos = ($y + $quietZone) * $moduleSize;
                    imagefilledrectangle($img, $xPos, $yPos, $xPos + $moduleSize - 1, $yPos + $moduleSize - 1, $black);
                }
            }
        }

        // Output to buffer
        ob_start();
        imagepng($img);
        $imageData = ob_get_clean();
        imagedestroy($img);

        // Return base64 data URI
        return 'data:image/png;base64,' . base64_encode($imageData);
    }
}
