<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .timeline {
        position: relative;
        padding-left: 30px;
    }

    .timeline:before {
        content: '';
        position: absolute;
        left: 8px;
        top: 0;
        bottom: 0;
        width: 2px;
        background: #e0e0e0;
    }

    .timeline-item {
        position: relative;
        margin-bottom: 20px;
    }

    .timeline-item:before {
        content: '';
        position: absolute;
        left: -26px;
        top: 0;
        width: 16px;
        height: 16px;
        border-radius: 50%;
        background: white;
        border: 3px solid #667eea;
    }

    .purchase-item, .service-item {
        background: #f8f9fa;
        padding: 15px;
        border-radius: 10px;
        margin-bottom: 15px;
        border-left: 4px solid #667eea;
        transition: all 0.3s;
    }

    .purchase-item:hover, .service-item:hover {
        transform: translateX(5px);
        box-shadow: 0 3px 10px rgba(0,0,0,0.1);
    }

    .active-service-card {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        border-radius: 15px;
        padding: 20px;
        margin-bottom: 15px;
        position: relative;
        overflow: hidden;
    }

    .active-service-card:before {
        content: '';
        position: absolute;
        top: -50%;
        right: -50%;
        width: 200%;
        height: 200%;
        background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, transparent 70%);
        animation: pulse 3s ease-in-out infinite;
    }

    @keyframes pulse {
        0%, 100% { transform: scale(1); opacity: 0.5; }
        50% { transform: scale(1.1); opacity: 0.8; }
    }

    .status-badge {
        display: inline-block;
        padding: 8px 16px;
        border-radius: 20px;
        font-size: 13px;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }

    .empty-state {
        text-align: center;
        padding: 60px 20px;
        color: #999;
    }

    .empty-state i {
        font-size: 80px;
        margin-bottom: 20px;
        opacity: 0.3;
    }

    .product-list {
        display: flex;
        flex-wrap: wrap;
        gap: 10px;
        margin-top: 10px;
    }

    .product-badge {
        background: #e8eaf6;
        padding: 5px 12px;
        border-radius: 15px;
        font-size: 12px;
        color: #667eea;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<!-- Statistics -->
<div class="row mb-4">
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="stats-card">
            <div class="icon" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white;">
                <i class="fas fa-shopping-cart"></i>
            </div>
            <h3><?php echo e($stats['total_purchases']); ?></h3>
            <p>Total Pembelian</p>
        </div>
    </div>
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="stats-card">
            <div class="icon" style="background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%); color: white;">
                <i class="fas fa-money-bill-wave"></i>
            </div>
            <h3>Rp <?php echo e(number_format($stats['total_spent'], 0, ',', '.')); ?></h3>
            <p>Total Belanja</p>
        </div>
    </div>
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="stats-card">
            <div class="icon" style="background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%); color: white;">
                <i class="fas fa-tools"></i>
            </div>
            <h3><?php echo e($stats['total_services']); ?></h3>
            <p>Total Service</p>
        </div>
    </div>
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="stats-card">
            <div class="icon" style="background: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%); color: white;">
                <i class="fas fa-spinner"></i>
            </div>
            <h3><?php echo e($stats['active_services']); ?></h3>
            <p>Service Aktif</p>
        </div>
    </div>
</div>

<!-- Active Services -->
<?php if($activeServices->count() > 0): ?>
<div class="section-card">
    <h4><i class="fas fa-exclamation-circle"></i> Service Aktif - Sedang Dikerjakan</h4>
    <?php $__currentLoopData = $activeServices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="active-service-card">
        <div class="row align-items-center">
            <div class="col-md-8">
                <h5 style="margin: 0 0 10px 0; font-weight: 600;">
                    <i class="fas fa-mobile-alt"></i> <?php echo e($service->device_brand); ?> <?php echo e($service->device_model); ?>

                </h5>
                <p style="margin: 5px 0; opacity: 0.9;">
                    <i class="fas fa-hashtag"></i> <?php echo e($service->service_number); ?>

                </p>
                <p style="margin: 5px 0; opacity: 0.9;">
                    <i class="fas fa-exclamation-triangle"></i> Keluhan: <?php echo e(Str::limit($service->complaint, 50)); ?>

                </p>
                <?php if($service->diagnosis): ?>
                <p style="margin: 5px 0; opacity: 0.9;">
                    <i class="fas fa-stethoscope"></i> Diagnosa: <?php echo e(Str::limit($service->diagnosis, 50)); ?>

                </p>
                <?php endif; ?>
                <p style="margin: 5px 0; opacity: 0.9;">
                    <i class="fas fa-calendar"></i> <?php echo e(\Carbon\Carbon::parse($service->service_date)->format('d M Y')); ?>

                </p>
            </div>
            <div class="col-md-4 text-center">
                <div class="status-badge" style="background: rgba(255,255,255,0.9); color: #667eea; display: block; margin-bottom: 15px;">
                    <?php echo e(strtoupper($service->status)); ?>

                </div>
                <a href="<?php echo e(route('customer.service.detail', $service->id)); ?>" class="btn btn-light btn-sm">
                    <i class="fas fa-eye"></i> Lihat Detail
                </a>
            </div>
        </div>
    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>
<?php endif; ?>

<div class="row">
    <!-- History Pembelian -->
    <div class="col-lg-6 mb-4">
        <div class="section-card">
            <h4><i class="fas fa-shopping-bag"></i> Riwayat Pembelian</h4>

            <?php if($purchases->count() > 0): ?>
                <?php $__currentLoopData = $purchases->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $purchase): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="purchase-item">
                    <div class="d-flex justify-content-between align-items-start">
                        <div>
                            <h6 style="margin: 0 0 5px 0; font-weight: 600;">
                                <i class="fas fa-receipt"></i> <?php echo e($purchase->sale_number); ?>

                            </h6>
                            <p style="margin: 3px 0; font-size: 13px; color: #666;">
                                <i class="fas fa-calendar"></i> <?php echo e(\Carbon\Carbon::parse($purchase->sale_date)->format('d M Y, H:i')); ?>

                            </p>
                            <p style="margin: 3px 0; font-size: 13px; color: #666;">
                                <i class="fas fa-map-marker-alt"></i> <?php echo e($purchase->branch->name ?? '-'); ?>

                            </p>
                            <?php if($purchase->saleDetails->count() > 0): ?>
                            <div class="product-list">
                                <?php $__currentLoopData = $purchase->saleDetails->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <span class="product-badge">
                                    <?php echo e($detail->product->name ?? 'Product'); ?> (<?php echo e($detail->quantity); ?>)
                                </span>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php if($purchase->saleDetails->count() > 3): ?>
                                <span class="product-badge">
                                    +<?php echo e($purchase->saleDetails->count() - 3); ?> lainnya
                                </span>
                                <?php endif; ?>
                            </div>
                            <?php endif; ?>
                        </div>
                        <div class="text-right">
                            <h5 style="margin: 0; color: #667eea; font-weight: 700;">
                                Rp <?php echo e(number_format($purchase->total_amount, 0, ',', '.')); ?>

                            </h5>
                            <span class="badge badge-success mt-2"><?php echo e($purchase->payment_method); ?></span>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <?php if($purchases->count() > 5): ?>
                <p class="text-center text-muted" style="margin-top: 10px; font-size: 13px;">
                    Menampilkan 5 dari <?php echo e($purchases->count()); ?> transaksi
                </p>
                <?php endif; ?>
            <?php else: ?>
                <div class="empty-state">
                    <i class="fas fa-shopping-cart"></i>
                    <h5>Belum Ada Pembelian</h5>
                    <p>Anda belum melakukan pembelian produk.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- History Service -->
    <div class="col-lg-6 mb-4">
        <div class="section-card">
            <h4><i class="fas fa-wrench"></i> Riwayat Service</h4>

            <?php if($services->count() > 0): ?>
                <?php $__currentLoopData = $services->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="service-item">
                    <div class="d-flex justify-content-between align-items-start">
                        <div style="flex: 1;">
                            <h6 style="margin: 0 0 5px 0; font-weight: 600;">
                                <i class="fas fa-mobile-alt"></i> <?php echo e($service->device_brand); ?> <?php echo e($service->device_model); ?>

                            </h6>
                            <p style="margin: 3px 0; font-size: 13px; color: #666;">
                                <i class="fas fa-hashtag"></i> <?php echo e($service->service_number); ?>

                            </p>
                            <p style="margin: 3px 0; font-size: 13px; color: #666;">
                                <i class="fas fa-calendar"></i> <?php echo e(\Carbon\Carbon::parse($service->service_date)->format('d M Y')); ?>

                            </p>
                            <p style="margin: 3px 0; font-size: 13px; color: #666;">
                                <i class="fas fa-exclamation-triangle"></i> <?php echo e(Str::limit($service->complaint, 40)); ?>

                            </p>
                            <?php
                                $statusColor = match($service->status) {
                                    'menunggu diagnosa' => 'warning',
                                    'dalam pengerjaan' => 'info',
                                    'menunggu sparepart' => 'secondary',
                                    'selesai' => 'success',
                                    'diambil' => 'success',
                                    'dibatalkan' => 'danger',
                                    default => 'primary'
                                };
                            ?>
                            <span class="badge badge-<?php echo e($statusColor); ?> mt-2"><?php echo e(strtoupper($service->status)); ?></span>
                        </div>
                        <div class="text-right ml-3">
                            <?php if($service->total_cost > 0): ?>
                            <h6 style="margin: 0 0 10px 0; color: #667eea; font-weight: 700;">
                                Rp <?php echo e(number_format($service->total_cost, 0, ',', '.')); ?>

                            </h6>
                            <?php endif; ?>
                            <a href="<?php echo e(route('customer.service.detail', $service->id)); ?>" class="btn btn-sm btn-outline-primary">
                                <i class="fas fa-eye"></i> Detail
                            </a>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <?php if($services->count() > 5): ?>
                <p class="text-center text-muted" style="margin-top: 10px; font-size: 13px;">
                    Menampilkan 5 dari <?php echo e($services->count()); ?> service
                </p>
                <?php endif; ?>
            <?php else: ?>
                <div class="empty-state">
                    <i class="fas fa-tools"></i>
                    <h5>Belum Ada Service</h5>
                    <p>Anda belum pernah melakukan service produk.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Info Kontak -->
<div class="section-card">
    <h4><i class="fas fa-info-circle"></i> Informasi Kontak</h4>
    <div class="row">
        <div class="col-md-4">
            <p style="margin: 5px 0;"><strong>Nama:</strong> <?php echo e($customer->name); ?></p>
        </div>
        <div class="col-md-4">
            <p style="margin: 5px 0;"><strong>WhatsApp:</strong> <?php echo e($customer->phone); ?></p>
        </div>
        <div class="col-md-4">
            <p style="margin: 5px 0;"><strong>Email:</strong> <?php echo e($customer->email); ?></p>
        </div>
        <div class="col-md-12 mt-2">
            <p style="margin: 5px 0;"><strong>Alamat:</strong> <?php echo e($customer->address); ?></p>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.customer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp82\htdocs\umi-cell\laravel\resources\views/customer/dashboard.blade.php ENDPATH**/ ?>