<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;

Route::get('/', [App\Http\Controllers\Auth\LoginController::class, 'ShowLoginForm']);

Auth::routes(['register' => false]);

// Customer Dashboard Routes
Route::prefix('customer')->middleware(['auth', 'role:customer'])->group(function () {
    Route::get('/dashboard', [App\Http\Controllers\Customer\CustomerDashboardController::class, 'index'])->name('customer.dashboard');
    Route::get('/service/{id}', [App\Http\Controllers\Customer\CustomerDashboardController::class, 'serviceDetail'])->name('customer.service.detail');
});

Route::prefix('admin')->group(function () {

    Route::group(['middleware' => 'auth'], function(){

        //dashboard
        Route::get('/home', [App\Http\Controllers\Spatie\HomeController::class, 'index'])->name('home');

        /////////////////////////
        // SETTING
        /////////////////////////

        //permissions
        Route::resource('/permission', App\Http\Controllers\Spatie\PermissionController::class, ['except' => ['show', 'create', 'edit', 'update', 'delete'] ,'as' => 'admin']);

        //role
        Route::get('/role', [App\Http\Controllers\Spatie\RoleController::class, 'index'])->name('role');
        Route::post('/role/save', [App\Http\Controllers\Spatie\RoleController::class, 'save'])->name('role.save');
        Route::put('/role/{role}', [App\Http\Controllers\Spatie\RoleController::class, 'update'])->name('role.update');
        Route::delete('/role/{role}', [App\Http\Controllers\Spatie\RoleController::class, 'delete'])->name('role.delete');

        //users
        Route::get('/user', [App\Http\Controllers\Spatie\UserController::class, 'index'])->name('user');
        Route::post('/user/save', [App\Http\Controllers\Spatie\UserController::class, 'save'])->name('user.save');
        Route::put('/user/{user}', [App\Http\Controllers\Spatie\UserController::class, 'update'])->name('user.update');
        Route::delete('/user/{user}', [App\Http\Controllers\Spatie\UserController::class, 'delete'])->name('user.delete');

        /////////////////////////
        // MASTER
        /////////////////////////

        //branch
        Route::get('/branch', [App\Http\Controllers\Master\BranchesController::class, 'index'])->name('branch');
        Route::post('/branch/save', [App\Http\Controllers\Master\BranchesController::class, 'save'])->name('branch.save');
        Route::put('/branch/{branch}', [App\Http\Controllers\Master\BranchesController::class, 'update'])->name('branch.update');
        Route::delete('/branch/{branch}', [App\Http\Controllers\Master\BranchesController::class, 'delete'])->name('branch.delete');
        Route::get('/branch/download-template', [App\Http\Controllers\Master\BranchesController::class, 'downloadTemplate'])->name('branch.download-template');
        Route::post('/branch/import-excel', [App\Http\Controllers\Master\BranchesController::class, 'importExcel'])->name('branch.import-excel');

        //category
        Route::get('/category', [App\Http\Controllers\Master\CategoriesController::class, 'index'])->name('category');
        Route::post('/category/save', [App\Http\Controllers\Master\CategoriesController::class, 'save'])->name('category.save');
        Route::put('/category/{category}', [App\Http\Controllers\Master\CategoriesController::class, 'update'])->name('category.update');
        Route::delete('/category/{category}', [App\Http\Controllers\Master\CategoriesController::class, 'delete'])->name('category.delete');
        Route::get('/category/download-template', [App\Http\Controllers\Master\CategoriesController::class, 'downloadTemplate'])->name('category.download-template');
        Route::post('/category/import-excel', [App\Http\Controllers\Master\CategoriesController::class, 'importExcel'])->name('category.import-excel');

        //brand
        Route::get('/brand', [App\Http\Controllers\Master\BrandController::class, 'index'])->name('brand');
        Route::post('/brand/save', [App\Http\Controllers\Master\BrandController::class, 'save'])->name('brand.save');
        Route::put('/brand/{brand}', [App\Http\Controllers\Master\BrandController::class, 'update'])->name('brand.update');
        Route::delete('/brand/{brand}', [App\Http\Controllers\Master\BrandController::class, 'delete'])->name('brand.delete');
        Route::get('/brand/download-template', [App\Http\Controllers\Master\BrandController::class, 'downloadTemplate'])->name('brand.download-template');
        Route::post('/brand/import-excel', [App\Http\Controllers\Master\BrandController::class, 'importExcel'])->name('brand.import-excel');

        //supplier
        Route::get('/supplier', [App\Http\Controllers\Master\SuppliersController::class, 'index'])->name('supplier');
        Route::post('/supplier/save', [App\Http\Controllers\Master\SuppliersController::class, 'save'])->name('supplier.save');
        Route::put('/supplier/{supplier}', [App\Http\Controllers\Master\SuppliersController::class, 'update'])->name('supplier.update');
        Route::delete('/supplier/{supplier}', [App\Http\Controllers\Master\SuppliersController::class, 'delete'])->name('supplier.delete');
        Route::get('/supplier/download-template', [App\Http\Controllers\Master\SuppliersController::class, 'downloadTemplate'])->name('supplier.download-template');
        Route::post('/supplier/import-excel', [App\Http\Controllers\Master\SuppliersController::class, 'importExcel'])->name('supplier.import-excel');

        //customer
        Route::get('/customer', [App\Http\Controllers\Master\CustomerController::class, 'index'])->name('customer');
        Route::post('/customer/save', [App\Http\Controllers\Master\CustomerController::class, 'save'])->name('customer.save');
        Route::put('/customer/{customer}', [App\Http\Controllers\Master\CustomerController::class, 'update'])->name('customer.update');
        Route::delete('/customer/{customer}', [App\Http\Controllers\Master\CustomerController::class, 'delete'])->name('customer.delete');
        Route::get('/customer/download-template', [App\Http\Controllers\Master\CustomerController::class, 'downloadTemplate'])->name('customer.download-template');
        Route::post('/customer/import-excel', [App\Http\Controllers\Master\CustomerController::class, 'importExcel'])->name('customer.import-excel');

        /////////////////////////
        // PRODUCT
        /////////////////////////

        //product
        Route::get('/product', [App\Http\Controllers\Product\ProductController::class, 'index'])->name('product');
        Route::get('/product/find-product-by-barcode', [App\Http\Controllers\Product\ProductController::class, 'findProductByBarcode'])->name('product.find-product-by-barcode');
        Route::get('/product/download-products-list-pdf', [App\Http\Controllers\Product\ProductController::class, 'downloadProductsListPdf'])->name('product.download-products-list-pdf');
        Route::post('/product/save', [App\Http\Controllers\Product\ProductController::class, 'save'])->name('product.save');
        Route::get('/product/download-template', [App\Http\Controllers\Product\ProductController::class, 'downloadTemplate'])->name('product.download-template');
        Route::post('/product/import-excel', [App\Http\Controllers\Product\ProductController::class, 'importExcel'])->name('product.import-excel');
        Route::put('/product/{product}', [App\Http\Controllers\Product\ProductController::class, 'update'])->name('product.update');
        Route::delete('/product/{product}', [App\Http\Controllers\Product\ProductController::class, 'delete'])->name('product.delete');
        Route::get('/product/{product}', [App\Http\Controllers\Product\ProductController::class, 'show'])->name('product.show');
        Route::get('/product/{product}/qrcode-jpg', [App\Http\Controllers\Product\ProductController::class, 'downloadQrCodeJpg'])->name('product.qrcode-jpg');

        /////////////////////////
        // TRANSACTION
        /////////////////////////

        //purchase
        Route::get('/purchase', [App\Http\Controllers\Transaction\PurchaseController::class, 'index'])->name('purchase');
        Route::get('/purchase/create', [App\Http\Controllers\Transaction\PurchaseController::class, 'create'])->name('purchase.create');
        Route::get('/purchase/get-product-price', [App\Http\Controllers\Transaction\PurchaseController::class, 'getProductPrice'])->name('purchase.get-product-price');
        Route::get('/purchase/get-products-by-branch', [App\Http\Controllers\Transaction\PurchaseController::class, 'getProductsByBranch'])->name('purchase.get-products-by-branch');
        Route::get('/purchase/find-product-by-barcode', [App\Http\Controllers\Transaction\PurchaseController::class, 'findProductByBarcode'])->name('purchase.find-product-by-barcode');
        Route::get('/purchase/find-purchase-by-barcode', [App\Http\Controllers\Transaction\PurchaseController::class, 'findPurchaseByBarcode'])->name('purchase.find-purchase-by-barcode');
        Route::post('/purchase/save', [App\Http\Controllers\Transaction\PurchaseController::class, 'save'])->name('purchase.save');
        Route::get('/purchase/{purchase}', [App\Http\Controllers\Transaction\PurchaseController::class, 'show'])->name('purchase.show');
        Route::get('/purchase/{purchase}/invoice-pdf', [App\Http\Controllers\Transaction\PurchaseController::class, 'exportInvoicePdf'])->name('purchase.invoice-pdf');
        Route::get('/purchase/{purchase}/qrcode-jpg', [App\Http\Controllers\Transaction\PurchaseController::class, 'downloadQrCodeJpg'])->name('purchase.qrcode-jpg');
        Route::get('/purchase/{purchase}/edit', [App\Http\Controllers\Transaction\PurchaseController::class, 'edit'])->name('purchase.edit');
        Route::put('/purchase/{purchase}', [App\Http\Controllers\Transaction\PurchaseController::class, 'update'])->name('purchase.update');
        Route::delete('/purchase/{purchase}', [App\Http\Controllers\Transaction\PurchaseController::class, 'delete'])->name('purchase.delete');

        //sale
        Route::get('/sale', [App\Http\Controllers\Transaction\SaleController::class, 'index'])->name('sale');
        Route::get('/sale/create', [App\Http\Controllers\Transaction\SaleController::class, 'create'])->name('sale.create');
        Route::get('/sale/get-product-data', [App\Http\Controllers\Transaction\SaleController::class, 'getProductData'])->name('sale.get-product-data');
        Route::get('/sale/get-products-by-branch', [App\Http\Controllers\Transaction\SaleController::class, 'getProductsByBranch'])->name('sale.get-products-by-branch');
        Route::get('/sale/find-product-by-barcode', [App\Http\Controllers\Transaction\SaleController::class, 'findProductByBarcode'])->name('sale.find-product-by-barcode');
        Route::get('/sale/find-sale-by-barcode', [App\Http\Controllers\Transaction\SaleController::class, 'findSaleByBarcode'])->name('sale.find-sale-by-barcode');
        Route::post('/sale/save', [App\Http\Controllers\Transaction\SaleController::class, 'save'])->name('sale.save');
        Route::get('/sale/{sale}', [App\Http\Controllers\Transaction\SaleController::class, 'show'])->name('sale.show');
        Route::get('/sale/{sale}/invoice-pdf', [App\Http\Controllers\Transaction\SaleController::class, 'exportInvoicePdf'])->name('sale.invoice-pdf');
        Route::get('/sale/{sale}/qrcode-jpg', [App\Http\Controllers\Transaction\SaleController::class, 'downloadQrCodeJpg'])->name('sale.qrcode-jpg');
        Route::get('/sale/{sale}/edit', [App\Http\Controllers\Transaction\SaleController::class, 'edit'])->name('sale.edit');
        Route::put('/sale/{sale}', [App\Http\Controllers\Transaction\SaleController::class, 'update'])->name('sale.update');
        Route::delete('/sale/{sale}', [App\Http\Controllers\Transaction\SaleController::class, 'delete'])->name('sale.delete');

        //stock movement
        Route::get('/stock-movement', [App\Http\Controllers\Transaction\StockMovementController::class, 'index'])->name('stock-movement');

        //stock opname
        Route::get('/stock-opname', [App\Http\Controllers\Transaction\StockOpnameController::class, 'index'])->name('stock-opname');
        Route::get('/stock-opname/create', [App\Http\Controllers\Transaction\StockOpnameController::class, 'create'])->name('stock-opname.create');
        Route::get('/stock-opname/get-products', [App\Http\Controllers\Transaction\StockOpnameController::class, 'getProductsByBranch'])->name('stock-opname.get-products');
        Route::post('/stock-opname/save', [App\Http\Controllers\Transaction\StockOpnameController::class, 'save'])->name('stock-opname.save');
        Route::get('/stock-opname/{stockOpname}', [App\Http\Controllers\Transaction\StockOpnameController::class, 'show'])->name('stock-opname.show');
        Route::get('/stock-opname/{stockOpname}/edit', [App\Http\Controllers\Transaction\StockOpnameController::class, 'edit'])->name('stock-opname.edit');
        Route::put('/stock-opname/{stockOpname}', [App\Http\Controllers\Transaction\StockOpnameController::class, 'update'])->name('stock-opname.update');
        Route::delete('/stock-opname/{stockOpname}', [App\Http\Controllers\Transaction\StockOpnameController::class, 'delete'])->name('stock-opname.delete');

        //service
        Route::get('/service', [App\Http\Controllers\Transaction\ServiceController::class, 'index'])->name('services.index');
        Route::get('/service/find-service-by-barcode', [App\Http\Controllers\Transaction\ServiceController::class, 'findServiceByBarcode'])->name('service.find-service-by-barcode');
        Route::get('/service/create', [App\Http\Controllers\Transaction\ServiceController::class, 'create'])->name('services.create');
        Route::post('/service', [App\Http\Controllers\Transaction\ServiceController::class, 'store'])->name('services.store');
        Route::get('/service/{service}', [App\Http\Controllers\Transaction\ServiceController::class, 'show'])->name('services.show');
        Route::get('/service/{service}/qrcode-jpg', [App\Http\Controllers\Transaction\ServiceController::class, 'downloadQrCodeJpg'])->name('service.qrcode-jpg');
        Route::get('/service/{service}/edit', [App\Http\Controllers\Transaction\ServiceController::class, 'edit'])->name('services.edit');
        Route::put('/service/{service}', [App\Http\Controllers\Transaction\ServiceController::class, 'update'])->name('services.update');
        Route::delete('/service/{service}', [App\Http\Controllers\Transaction\ServiceController::class, 'destroy'])->name('services.destroy');
        Route::post('/service/{service}/update-status', [App\Http\Controllers\Transaction\ServiceController::class, 'updateStatus'])->name('services.update-status');
        Route::get('/service/{service}/print', [App\Http\Controllers\Transaction\ServiceController::class, 'print'])->name('services.print');

        /////////////////////////
        // REPORT
        /////////////////////////

        //report - service
        Route::get('/report/service/status', [App\Http\Controllers\Report\ServiceReportController::class, 'statusReport'])->name('report.service.status');
        Route::get('/report/service/status/export-pdf', [App\Http\Controllers\Report\ServiceReportController::class, 'exportStatusPdf'])->name('report.service.status.export-pdf');
        Route::get('/report/service/status/export-excel', [App\Http\Controllers\Report\ServiceReportController::class, 'exportStatusExcel'])->name('report.service.status.export-excel');

        Route::get('/report/service/technician', [App\Http\Controllers\Report\ServiceReportController::class, 'technicianReport'])->name('report.service.technician');
        Route::get('/report/service/technician/export-pdf', [App\Http\Controllers\Report\ServiceReportController::class, 'exportTechnicianPdf'])->name('report.service.technician.export-pdf');
        Route::get('/report/service/technician/export-excel', [App\Http\Controllers\Report\ServiceReportController::class, 'exportTechnicianExcel'])->name('report.service.technician.export-excel');

        Route::get('/report/service/revenue', [App\Http\Controllers\Report\ServiceReportController::class, 'revenueReport'])->name('report.service.revenue');
        Route::get('/report/service/revenue/export-pdf', [App\Http\Controllers\Report\ServiceReportController::class, 'exportRevenuePdf'])->name('report.service.revenue.export-pdf');
        Route::get('/report/service/revenue/export-excel', [App\Http\Controllers\Report\ServiceReportController::class, 'exportRevenueExcel'])->name('report.service.revenue.export-excel');

        //report - profit loss
        Route::get('/report/profit-loss', [App\Http\Controllers\Report\ProfitLossController::class, 'index'])->name('report.profit-loss');
        Route::get('/report/profit-loss/export-pdf', [App\Http\Controllers\Report\ProfitLossController::class, 'exportPdf'])->name('report.profit-loss.export-pdf');
        Route::get('/report/profit-loss/export-excel', [App\Http\Controllers\Report\ProfitLossController::class, 'exportExcel'])->name('report.profit-loss.export-excel');
        Route::get('/report/profit-loss/export-product-analysis-pdf', [App\Http\Controllers\Report\ProfitLossController::class, 'exportProductAnalysisPdf'])->name('report.profit-loss.export-product-analysis-pdf');
        Route::get('/report/profit-loss/export-product-analysis-excel', [App\Http\Controllers\Report\ProfitLossController::class, 'exportProductAnalysisExcel'])->name('report.profit-loss.export-product-analysis-excel');

        //report - product list
        Route::get('/report/product-list', [App\Http\Controllers\Report\ProductListReportController::class, 'index'])->name('report.product-list');
        Route::get('/report/product-list/export-pdf', [App\Http\Controllers\Report\ProductListReportController::class, 'exportPdf'])->name('report.product-list.export-pdf');

    });

});
