@section('heading', 'Detail Stock Opname')
@extends('layouts.app')
@section('content')
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Detail Stock Opname</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{route('home')}}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{route('stock-opname')}}">Stock Opname</a></li>
                    <li class="breadcrumb-item active">Detail</li>
                </ol>
            </div>
        </div>
    </div>
</section>

<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Detail Produk</h3>
                    </div>
                    <div class="card-body">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th style="width: 5%;">No</th>
                                    <th>Produk</th>
                                    <th style="width: 12%;">Stok Sistem</th>
                                    <th style="width: 12%;">Stok Fisik</th>
                                    <th style="width: 12%;">Selisih</th>
                                    <th style="width: 20%;">Catatan</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($stockOpname->stockOpnameDetails as $index => $detail)
                                <tr>
                                    <td>{{$index + 1}}</td>
                                    <td>{{$detail->product->name}}</td>
                                    <td class="text-center">{{number_format($detail->system_stock, 0, ',', '.')}}</td>
                                    <td class="text-center">{{number_format($detail->physical_stock, 0, ',', '.')}}</td>
                                    <td class="text-center">
                                        @if($detail->difference > 0)
                                        <span class="badge badge-success">+{{number_format($detail->difference, 0, ',', '.')}}</span>
                                        @elseif($detail->difference < 0)
                                        <span class="badge badge-danger">{{number_format($detail->difference, 0, ',', '.')}}</span>
                                        @else
                                        <span class="badge badge-secondary">0</span>
                                        @endif
                                    </td>
                                    <td>{{$detail->notes ?? '-'}}</td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Informasi Stock Opname</h3>
                    </div>
                    <div class="card-body">
                        <table class="table table-sm">
                            <tr>
                                <th style="width: 40%;">No. Opname</th>
                                <td>{{$stockOpname->opname_number}}</td>
                            </tr>
                            <tr>
                                <th>Cabang</th>
                                <td>{{$stockOpname->branch->name}}</td>
                            </tr>
                            <tr>
                                <th>Tanggal</th>
                                <td>{{TanggalID($stockOpname->opname_date)}}</td>
                            </tr>
                            <tr>
                                <th>Status</th>
                                <td>
                                    @if($stockOpname->status == 'pending')
                                    <span class="badge badge-warning">Pending</span>
                                    @elseif($stockOpname->status == 'completed')
                                    <span class="badge badge-success">Selesai</span>
                                    @else
                                    <span class="badge badge-danger">Batal</span>
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <th>User</th>
                                <td>{{$stockOpname->user->name}}</td>
                            </tr>
                            <tr>
                                <th>Total Item</th>
                                <td>{{$stockOpname->stockOpnameDetails->count()}} item</td>
                            </tr>
                            @if($stockOpname->notes)
                            <tr>
                                <th>Catatan</th>
                                <td>{{$stockOpname->notes}}</td>
                            </tr>
                            @endif
                            <tr>
                                <th>Dibuat</th>
                                <td>{{TanggalID($stockOpname->created_at)}}</td>
                            </tr>
                        </table>
                    </div>
                    <div class="card-footer">
                        <a href="{{route('stock-opname')}}" class="btn btn-secondary btn-block">
                            <i class="fas fa-arrow-left"></i> Kembali
                        </a>
                        @can('stock-opnames.edit')
                        @if($stockOpname->status == 'pending')
                        <a href="{{route('stock-opname.edit', $stockOpname->id)}}" class="btn btn-primary btn-block">
                            <i class="fas fa-edit"></i> Edit
                        </a>
                        @endif
                        @endcan
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection
