@section('heading', 'Role')

@extends('layouts.app')

@section('content')


<style>
    .warning {
        background-color: yellow;
    }

</style>


<!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1> Roles </h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item">
                        <a href="{{route('home')}}">Dashboard</a>
                    </li>
                    <li class="breadcrumb-item active"> Roles </li>
                </ol>
            </div>
        </div>
    </div>
</section>

<!-- Main content -->
<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title"> <b>Roles</b> </h3>
                        <div class="card-tools">
                            @can('roles.create')
                                <button type="button" class="btn btn-success text-white btn-sm m-1" title="Tambah" data-toggle="modal" data-target="#modal-tambah">
                                    <i class="fas fa-plus-circle"></i> Tambah
                                </button>
                                <div class="modal fade" id="modal-tambah">
                                    <div class="modal-dialog modal-xl">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h4 class="modal-title"> Tambah Role </h4>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <form action="{{ route('role.save') }}" method="POST" enctype="multipart/form-data" id="form-tambah-role">
                                                @csrf
                                                <div class="modal-body">
                                                    <div class="form-group">
                                                        <label>Nama Role <span class="text-danger">*</span></label>
                                                        <input type="text" name="name" id="name-tambah" value="{{ old('name') }}" placeholder="Masukkan Nama Role" class="form-control @error('name') is-invalid @enderror" required>
                                                        @error('name')
                                                        <div class="invalid-feedback" style="display: block">
                                                            {{ $message }}
                                                        </div>
                                                        @enderror
                                                    </div>
                                                    <div class="form-group">
                                                        <label class="font-weight-bold">Permission</label>
                                                        @foreach ($permissions as $permission)
                                                        <div class="form-check form-check-inline">
                                                            <input class="form-check-input" type="checkbox" name="permissions[]" value="{{ $permission->name }}" id="check-{{ $permission->id }}">
                                                            <label class="form-check-label" for="check-{{ $permission->id }}">
                                                                {{ $permission->name }}
                                                            </label>
                                                        </div>
                                                        @endforeach
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="submit" class="btn btn-primary btn-submit">
                                                            <i class="fa fa-paper-plane"></i> Simpan
                                                        </button>
                                                        <button class="btn btn-warning text-white btn-reset" type="reset">
                                                            <i class="fa fa-redo"></i> Reset
                                                        </button>
                                                        <button type="button" class="btn btn-default" data-dismiss="modal">
                                                            <i class="fas fa-undo"></i> Kembali
                                                        </button>
                                                    </div>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                             @endcan
                        </div>
                    </div>
                    <div class="card-body">
                        <table id="example1" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th scope="col" style="text-align: center;width: 6%">NO.</th>
                                    <th scope="col" style="width: 15%">Nama Role</th>
                                    <th scope="col">Permission</th>
                                    <th scope="col" style="width: 15%;text-align: center">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $nomer = 1; ?>
                                @foreach ($roles as $no => $role)
                                <tr>
                                    <th>{{ $nomer++}}</th>
                                    <td>{{ $role->name }}</td>
                                    <td>
                                        @foreach($role->getPermissionNames() as $permission)
                                        <button class="btn btn-sm btn-success mb-1 mt-1 mr-1">{{ $permission }}</button>
                                        @endforeach
                                    </td>
                                    <td class="text-left">
                                        @can('roles.edit')
                                            <button type="button" class="btn btn-warning text-white btn-sm m-1" title="Edit" data-toggle="modal" data-target="#modal-edit-{{ $role->id }}">
                                                <i class="fas fa-pencil-alt"></i>
                                            </button>
                                            <div class="modal fade" id="modal-edit-{{ $role->id }}">
                                                <div class="modal-dialog modal-xl">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h4 class="modal-title"> Edit Data </h4>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <form action="{{ route('role.update', $role->id) }}" method="POST" enctype="multipart/form-data" class="form-edit-role">
                                                            @csrf
                                                            @method('PUT')
                                                            <div class="modal-body">
                                                                <div class="form-group">
                                                                    <label>Nama Role <span class="text-danger">*</span></label>
                                                                    <input type="text" name="name" value="{{ old('name', $role->name) }}" placeholder="Masukkan Nama Role" class="form-control @error('name') is-invalid @enderror" required>
                                                                    @error('name')
                                                                    <div class="invalid-feedback" style="display: block">
                                                                        {{ $message }}
                                                                    </div>
                                                                    @enderror
                                                                </div>
                                                                <div class="form-group">
                                                                    <label class="font-weight-bold">Permissions</label>
                                                                    @foreach ($permissions as $permission)
                                                                    <div class="form-check form-check-inline">
                                                                        <input class="form-check-input" type="checkbox" name="permissions[]" value="{{ $permission->name }}" id="check-edit-{{ $role->id }}-{{ $permission->id }}" @if($role->permissions->contains($permission)) checked @endif>
                                                                        <label class="form-check-label" for="check-edit-{{ $role->id }}-{{ $permission->id }}">
                                                                            {{ $permission->name }}
                                                                        </label>
                                                                    </div>
                                                                    @endforeach
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="submit" class="btn btn-primary btn-submit">
                                                                    <i class="fa fa-paper-plane"></i> Simpan
                                                                </button>
                                                                <button class="btn btn-warning text-white btn-reset" type="reset">
                                                                    <i class="fa fa-redo"></i> Reset
                                                                </button>
                                                                <button type="button" class="btn btn-default" data-dismiss="modal">
                                                                    <i class="fas fa-undo"></i> Kembali
                                                                </button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        @endcan
                                        @can('roles.delete')
                                            <form action="{{ route('role.delete', $role->id) }}" method="POST" style="display:inline;" class="delete-form-{{ $role->id }}">
                                                @csrf
                                                @method('DELETE')
                                                <button type="button" class="btn btn-danger btn-sm delete m-1" data-id="{{ $role->id}}" data-name="{{ $role->name}}" title="Hapus">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        @endcan
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- /.content -->

@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        // Validasi Form Tambah Role
        $('#form-tambah-role').on('submit', function(e) {
            var nameInput = $('#name-tambah').val().trim();

            if (nameInput === '') {
                e.preventDefault();
                e.stopPropagation();

                // Tambahkan class is-invalid
                $('#name-tambah').addClass('is-invalid');

                // Tampilkan pesan error jika belum ada
                if ($('#name-tambah').siblings('.invalid-feedback').length === 0) {
                    $('#name-tambah').after('<div class="invalid-feedback" style="display: block">Nama Role wajib diisi!</div>');
                }

                // Focus ke input
                $('#name-tambah').focus();

                return false;
            }
        });

        // Hapus error saat user mulai mengetik
        $('#name-tambah').on('input', function() {
            if ($(this).val().trim() !== '') {
                $(this).removeClass('is-invalid');
                $(this).siblings('.invalid-feedback').remove();
            }
        });

        // Validasi Form Edit Role
        $('.form-edit-role').on('submit', function(e) {
            var nameInput = $(this).find('input[name="name"]');

            if (nameInput.val().trim() === '') {
                e.preventDefault();
                e.stopPropagation();

                // Tambahkan class is-invalid
                nameInput.addClass('is-invalid');

                // Tampilkan pesan error jika belum ada
                if (nameInput.siblings('.invalid-feedback').length === 0) {
                    nameInput.after('<div class="invalid-feedback" style="display: block">Nama Role wajib diisi!</div>');
                }

                // Focus ke input
                nameInput.focus();

                return false;
            }
        });

        // Hapus error saat user mulai mengetik di form edit
        $('.form-edit-role input[name="name"]').on('input', function() {
            if ($(this).val().trim() !== '') {
                $(this).removeClass('is-invalid');
                $(this).siblings('.invalid-feedback').remove();
            }
        });
    });
</script>
@endpush

