@section('heading', 'Laporan Kinerja Teknisi')
@extends('layouts.app')
@section('content')
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Laporan Kinerja Teknisi</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{route('home')}}">Home</a></li>
                    <li class="breadcrumb-item active">Laporan Service - Teknisi</li>
                </ol>
            </div>
        </div>
    </div>
</section>

<section class="content">
    <div class="container-fluid">
        <!-- Filter Form -->
        <div class="card">
            <div class="card-header bg-primary">
                <h3 class="card-title">Filter Laporan</h3>
            </div>
            <div class="card-body">
                <form action="{{route('report.service.technician')}}" method="GET">
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Tanggal Mulai</label>
                                <input type="date" name="start_date" class="form-control" value="{{$startDate}}" required>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Tanggal Akhir</label>
                                <input type="date" name="end_date" class="form-control" value="{{$endDate}}" required>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>Teknisi</label>
                                <select name="technician_id" class="form-control">
                                    <option value="">Semua Teknisi</option>
                                    @foreach($technicians as $tech)
                                    <option value="{{$tech->id}}" {{$technicianId == $tech->id ? 'selected' : ''}}>
                                        {{$tech->name}}
                                    </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>Cabang</label>
                                <select name="branch_id" class="form-control">
                                    <option value="">Semua Cabang</option>
                                    @foreach($branches as $branch)
                                    <option value="{{$branch->id}}" {{$branchId == $branch->id ? 'selected' : ''}}>
                                        {{$branch->name}}
                                    </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>&nbsp;</label>
                                <button type="submit" class="btn btn-primary btn-block">
                                    <i class="fas fa-search"></i> Tampilkan
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
                <div class="row mt-2">
                    <div class="col-md-12">
                        <a href="{{route('report.service.technician.export-pdf', ['start_date' => $startDate, 'end_date' => $endDate, 'technician_id' => $technicianId, 'branch_id' => $branchId])}}" class="btn btn-danger" target="_blank">
                            <i class="fas fa-file-pdf"></i> Export PDF
                        </a>
                        <a href="{{route('report.service.technician.export-excel', ['start_date' => $startDate, 'end_date' => $endDate, 'technician_id' => $technicianId, 'branch_id' => $branchId])}}" class="btn btn-success">
                            <i class="fas fa-file-excel"></i> Export Excel
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Summary Cards -->
        <div class="row">
            <div class="col-lg-3 col-6">
                <div class="small-box bg-info">
                    <div class="inner">
                        <h3>{{$services->count()}}</h3>
                        <p>Total Service</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-wrench"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-6">
                <div class="small-box bg-success">
                    <div class="inner">
                        <h3>{{$services->where('status', 'selesai')->count()}}</h3>
                        <p>Selesai</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-check-circle"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-6">
                <div class="small-box bg-warning">
                    <div class="inner">
                        <h3>{{$technicianStats->count()}}</h3>
                        <p>Jumlah Teknisi</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-users"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-6">
                <div class="small-box bg-primary">
                    <div class="inner">
                        <h3>Rp {{number_format($services->where('status', 'selesai')->sum('total_cost') / 1000, 0)}}K</h3>
                        <p>Total Pendapatan</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-money-bill-wave"></i>
                    </div>
                </div>
            </div>
        </div>

        <!-- Statistik Teknisi Table -->
        <div class="card">
            <div class="card-header bg-success">
                <h3 class="card-title">Statistik Per Teknisi</h3>
            </div>
            <div class="card-body">
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>Teknisi</th>
                            <th class="text-center">Total Service</th>
                            <th class="text-center">Selesai</th>
                            <th class="text-center">Dalam Proses</th>
                            <th class="text-center">Dibatalkan</th>
                            <th class="text-center">Success Rate</th>
                            <th class="text-center">Avg. Durasi</th>
                            <th class="text-right">Total Pendapatan</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($technicianStats as $stat)
                        <tr>
                            <td><strong>{{$stat['technician_name']}}</strong></td>
                            <td class="text-center">{{$stat['total_services']}}</td>
                            <td class="text-center">
                                <span class="badge badge-success">{{$stat['completed']}}</span>
                            </td>
                            <td class="text-center">
                                <span class="badge badge-info">{{$stat['in_progress']}}</span>
                            </td>
                            <td class="text-center">
                                <span class="badge badge-danger">{{$stat['cancelled']}}</span>
                            </td>
                            <td class="text-center">
                                <span class="badge badge-{{$stat['success_rate'] >= 80 ? 'success' : ($stat['success_rate'] >= 60 ? 'warning' : 'danger')}}">
                                    {{$stat['success_rate']}}%
                                </span>
                            </td>
                            <td class="text-center">{{$stat['avg_duration_days']}} hari</td>
                            <td class="text-right">Rp {{number_format($stat['total_revenue'], 0, ',', '.')}}</td>
                        </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr class="font-weight-bold bg-light">
                            <td>TOTAL</td>
                            <td class="text-center">{{$technicianStats->sum('total_services')}}</td>
                            <td class="text-center">{{$technicianStats->sum('completed')}}</td>
                            <td class="text-center">{{$technicianStats->sum('in_progress')}}</td>
                            <td class="text-center">{{$technicianStats->sum('cancelled')}}</td>
                            <td class="text-center">-</td>
                            <td class="text-center">-</td>
                            <td class="text-right">Rp {{number_format($technicianStats->sum('total_revenue'), 0, ',', '.')}}</td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>

        <!-- Detail Services per Teknisi -->
        <div class="card">
            <div class="card-header bg-secondary">
                <h3 class="card-title">Detail Service</h3>
            </div>
            <div class="card-body">
                <table class="table table-bordered table-striped table-sm" id="serviceTable">
                    <thead>
                        <tr>
                            <th>No. Service</th>
                            <th>Tanggal</th>
                            <th>Customer</th>
                            <th>Device</th>
                            <th>Teknisi</th>
                            <th>Status</th>
                            <th>Durasi</th>
                            <th class="text-right">Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($services as $service)
                        <tr>
                            <td><a href="{{route('services.show', $service->id)}}">{{$service->service_number}}</a></td>
                            <td>{{$service->service_date->format('d/m/Y')}}</td>
                            <td>{{$service->customer->name}}</td>
                            <td>{{$service->device_brand}} {{$service->device_model}}</td>
                            <td>{{$service->technician->name ?? '-'}}</td>
                            <td>
                                @php
                                $badgeClass = match($service->status) {
                                    'selesai' => 'success',
                                    'dibatalkan' => 'danger',
                                    'siap diambil' => 'primary',
                                    default => 'warning'
                                };
                                @endphp
                                <span class="badge badge-{{$badgeClass}}">{{ucwords($service->status)}}</span>
                            </td>
                            <td>
                                @if($service->completed_at)
                                {{$service->service_date->diffInDays($service->completed_at)}} hari
                                @else
                                {{$service->service_date->diffInDays(now())}} hari (berjalan)
                                @endif
                            </td>
                            <td class="text-right">Rp {{number_format($service->total_cost, 0, ',', '.')}}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</section>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js@3.9.1/dist/chart.min.js"></script>
<script>
$(document).ready(function() {
    $('#serviceTable').DataTable({
        "responsive": true,
        "lengthChange": true,
        "autoWidth": false,
        "pageLength": 25,
        "order": [[1, 'desc']]
    });
});
</script>
@endpush
