@section('heading', 'Laporan Service Berdasarkan Status')
@extends('layouts.app')
@section('content')
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Laporan Service Berdasarkan Status </h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{route('home')}}">Home</a></li>
                    <li class="breadcrumb-item active">Laporan Service - Status </li>
                </ol>
            </div>
        </div>
    </div>
</section>

<section class="content">
    <div class="container-fluid">
        <!-- Filter Form -->
        <div class="card">
            <div class="card-header bg-primary">
                <h3 class="card-title">Filter Laporan</h3>
            </div>
            <div class="card-body">
                <form action="{{route('report.service.status')}}" method="GET">
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Tanggal Mulai</label>
                                <input type="date" name="start_date" class="form-control" value="{{$startDate}}" required>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Tanggal Akhir</label>
                                <input type="date" name="end_date" class="form-control" value="{{$endDate}}" required>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Cabang</label>
                                <select name="branch_id" class="form-control">
                                    <option value="">Semua Cabang</option>
                                    @foreach($branches as $branch)
                                    <option value="{{$branch->id}}" {{$branchId == $branch->id ? 'selected' : ''}}>
                                        {{$branch->name}}
                                    </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>&nbsp;</label>
                                <button type="submit" class="btn btn-primary btn-block">
                                    <i class="fas fa-search"></i> Tampilkan
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
                <div class="row mt-2">
                    <div class="col-md-12">
                        <a href="{{route('report.service.status.export-pdf', ['start_date' => $startDate, 'end_date' => $endDate, 'branch_id' => $branchId])}}" class="btn btn-danger" target="_blank">
                            <i class="fas fa-file-pdf"></i> Export PDF
                        </a>
                        <a href="{{route('report.service.status.export-excel', ['start_date' => $startDate, 'end_date' => $endDate, 'branch_id' => $branchId])}}" class="btn btn-success">
                            <i class="fas fa-file-excel"></i> Export Excel
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Summary Cards -->
        <div class="row">
            <div class="col-lg-3 col-6">
                <div class="small-box bg-info">
                    <div class="inner">
                        <h3>{{$services->count()}}</h3>
                        <p>Total Service</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-wrench"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-6">
                <div class="small-box bg-success">
                    <div class="inner">
                        <h3>{{$services->where('status', 'selesai')->count()}}</h3>
                        <p>Selesai</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-check-circle"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-6">
                <div class="small-box bg-warning">
                    <div class="inner">
                        <h3>{{$delayedServices->count()}}</h3>
                        <p>Tertunda (>3 hari)</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-exclamation-triangle"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-6">
                <div class="small-box bg-primary">
                    <div class="inner">
                        <h3>{{$readyToPickup->count()}}</h3>
                        <p>Siap Diambil</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-bell"></i>
                    </div>
                </div>
            </div>
        </div>

        <!-- Chart & Status Table -->
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header bg-info">
                        <h3 class="card-title">Statistik Per Status</h3>
                    </div>
                    <div class="card-body">
                        <table class="table table-bordered table-sm">
                            <thead>
                                <tr>
                                    <th>Status</th>
                                    <th class="text-center">Jumlah</th>
                                    <th class="text-right">Total Nilai</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($statusStats as $status => $stat)
                                <tr>
                                    <td>{{ucwords($status)}}</td>
                                    <td class="text-center">{{$stat['count']}}</td>
                                    <td class="text-right">Rp {{number_format($stat['total_value'], 0, ',', '.')}}</td>
                                </tr>
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr class="font-weight-bold">
                                    <td>TOTAL</td>
                                    <td class="text-center">{{$services->count()}}</td>
                                    <td class="text-right">Rp {{number_format($services->sum('total_cost'), 0, ',', '.')}}</td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Service Tertunda -->
        @if($delayedServices->count() > 0)
        <div class="card">
            <div class="card-header bg-warning">
                <h3 class="card-title">Service Tertunda (>3 hari)</h3>
            </div>
            <div class="card-body">
                <table class="table table-bordered table-striped table-sm">
                    <thead>
                        <tr>
                            <th>No. Service</th>
                            <th>Tanggal</th>
                            <th>Customer</th>
                            <th>Device</th>
                            <th>Status</th>
                            <th>Teknisi</th>
                            <th>Lama (Hari)</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($delayedServices as $service)
                        <tr>
                            <td><a href="{{route('services.show', $service->id)}}">{{$service->service_number}}</a></td>
                            <td>{{$service->service_date->format('d/m/Y')}}</td>
                            <td>{{$service->customer->name}}</td>
                            <td>{{$service->device_brand}} {{$service->device_model}}</td>
                            <td><span class="badge badge-warning">{{ucwords($service->status)}}</span></td>
                            <td>{{$service->technician->name ?? '-'}}</td>
                            {{-- <td>{{$service->service_date->diffInDays(now())}} hari</td> --}}
                            <td>{{ floor($service->service_date->diffInDays(now())) }} hari</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        @endif

        <!-- Service Siap Diambil -->
        @if($readyToPickup->count() > 0)
        <div class="card">
            <div class="card-header bg-primary">
                <h3 class="card-title">Service Siap Diambil</h3>
            </div>
            <div class="card-body">
                <table class="table table-bordered table-striped table-sm">
                    <thead>
                        <tr>
                            <th>No. Service</th>
                            <th>Tanggal</th>
                            <th>Customer</th>
                            <th>Device</th>
                            <th>Teknisi</th>
                            <th>Total Biaya</th>
                            <th>Sisa Bayar</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($readyToPickup as $service)
                        <tr>
                            <td><a href="{{route('services.show', $service->id)}}">{{$service->service_number}}</a></td>
                            <td>{{$service->service_date->format('d/m/Y')}}</td>
                            <td>{{$service->customer->name}}</td>
                            <td>{{$service->device_brand}} {{$service->device_model}}</td>
                            <td>{{$service->technician->name ?? '-'}}</td>
                            <td class="text-right">Rp {{number_format($service->total_cost, 0, ',', '.')}}</td>
                            <td class="text-right">Rp {{number_format($service->remaining_payment, 0, ',', '.')}}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        @endif

        <!-- Detail All Services -->
        <div class="card">
            <div class="card-header bg-secondary">
                <h3 class="card-title">Detail Semua Service</h3>
            </div>
            <div class="card-body">
                <table class="table table-bordered table-striped table-sm" id="serviceTable">
                    <thead>
                        <tr>
                            <th>No. Service</th>
                            <th>Tanggal</th>
                            <th>Customer</th>
                            <th>Device</th>
                            <th>Status</th>
                            <th>Cabang</th>
                            <th>Teknisi</th>
                            <th class="text-right">Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($services as $service)
                        <tr>
                            <td><a href="{{route('services.show', $service->id)}}">{{$service->service_number}}</a></td>
                            <td>{{$service->service_date->format('d/m/Y')}}</td>
                            <td>{{$service->customer->name}}</td>
                            <td>{{$service->device_brand}} {{$service->device_model}}</td>
                            <td>
                                @php
                                $badgeClass = match($service->status) {
                                    'menunggu diagnosa' => 'warning',
                                    'sedang diagnosa' => 'info',
                                    'menunggu persetujuan' => 'primary',
                                    'menunggu spare part' => 'secondary',
                                    'dalam pengerjaan' => 'info',
                                    'quality control' => 'success',
                                    'siap diambil' => 'primary',
                                    'selesai' => 'success',
                                    'dibatalkan' => 'danger',
                                    default => 'secondary'
                                };
                                @endphp
                                <span class="badge badge-{{$badgeClass}}">{{ucwords($service->status)}}</span>
                            </td>
                            <td>{{$service->branch->name}}</td>
                            <td>{{$service->technician->name ?? '-'}}</td>
                            <td class="text-right">Rp {{number_format($service->total_cost, 0, ',', '.')}}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</section>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    $('#serviceTable').DataTable({
        "responsive": true,
        "lengthChange": true,
        "autoWidth": false,
        "pageLength": 25,
        "order": [[1, 'desc']]
    });
});
</script>
@endpush
