<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Daftar Produk</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: Arial, sans-serif;
            padding: 5mm;
            font-size: 8pt; /* UBAH ANGKA INI UNTUK BESAR KECIL TEXT (misal: 6pt, 8pt, 10pt, 12pt, 14pt) */
        }

        h1 {
            text-align: center;
            margin-bottom: 20mm;
            font-size: 24pt;
            color: #333;
        }

        .products-grid {
            display: table;
            width: 100%;
            border-collapse: collapse;
            table-layout: fixed; /* PATENKAN LEBAR KOLOM - tidak mengikuti panjang text */
        }

        .product-row {
            display: table-row;
        }

        .product-item {
            display: table-cell;
            padding: 3mm 2mm;
            border: 2px solid #333;
            text-align: center;
            font-weight: bold;
            vertical-align: middle;
            width: 20%; /* 5 columns = 20% each */
            height: 10mm;
            word-wrap: break-word;
            overflow: hidden;
        }

        /* Add spacing between rows */
        .product-row:not(:last-child) .product-item {
            border-bottom: none;
        }

        @page {
            size: A4 portrait;
            margin: 5mm; /* MARGIN KERTAS - left right top bottom (ubah angka ini untuk mepet/renggang) */
        }

        @media print {
            body {
                padding: 0;
            }
        }
    </style>
</head>
<body>
    <div class="products-grid">
        @foreach($products->chunk(5) as $rowIndex => $productsRow)
            <div class="product-row">
                @foreach($productsRow as $product)
                    <div class="product-item">
                        00{{ $product->id }} - {{ $product->name }}
                    </div>
                @endforeach

                @php
                    $remaining = 5 - $productsRow->count();
                @endphp

                @for($i = 0; $i < $remaining; $i++)
                    <div class="product-item" style="border-color: transparent;">
                        &nbsp;
                    </div>
                @endfor
            </div>
        @endforeach
    </div>
</body>
</html>
