@section('heading', 'Cabang')

@extends('layouts.app')

@section('content')


<style>
    .warning {
        background-color: yellow;
    }

</style>


<!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1> Cabang </h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item">
                        <a href="{{route('home')}}">Dashboard</a>
                    </li>
                    <li class="breadcrumb-item active"> Cabang </li>
                </ol>
            </div>
        </div>
    </div>
</section>

<!-- Main content -->
<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title"> <b>Cabang</b> </h3>
                        <div class="card-tools">
                            @can('branches.create')
                                <button type="button" class="btn btn-primary text-white btn-sm m-1" title="Import Excel" data-toggle="modal" data-target="#modal-import">
                                    <i class="fas fa-file-excel"></i> Import Excel
                                </button>
                                <button type="button" class="btn btn-success text-white btn-sm m-1" title="Tambah" data-toggle="modal" data-target="#modal-tambah">
                                    <i class="fas fa-plus-circle"></i> Tambah
                                </button>
                                <div class="modal fade" id="modal-tambah">
                                    <div class="modal-dialog modal-xl">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h4 class="modal-title"> Tambah Cabang </h4>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <form action="{{ route('branch.save') }}" method="POST" enctype="multipart/form-data" id="form-tambah-branch">
                                                @csrf
                                                <div class="modal-body">
                                                    <div class="form-group">
                                                        <label>Nama Cabang <span class="text-danger">*</span></label>
                                                        <input type="text" name="name" value="{{ old('name') }}" placeholder="Masukkan Nama Cabang" class="form-control @error('name') is-invalid @enderror" required>
                                                        @error('name')
                                                        <div class="invalid-feedback" style="display: block">
                                                            {{ $message }}
                                                        </div>
                                                        @enderror
                                                    </div>
                                                    <div class="form-group">
                                                        <label>Alamat <span class="text-danger">*</span></label>
                                                        <textarea name="address" placeholder="Masukkan Alamat"
                                                            class="form-control @error('address') is-invalid @enderror"
                                                            required>{{ old('address') }}</textarea>
                                                        @error('address')
                                                        <div class="invalid-feedback" style="display: block">
                                                            {{ $message }}
                                                        </div>
                                                        @enderror
                                                    </div>
                                                    <div class="form-group">
                                                        <label>NO WhatsApp <span class="text-danger">*</span></label>
                                                        <input type="text" name="phone" value="{{ old('phone') }}" placeholder="Masukkan NO WhatsApp" class="form-control @error('phone') is-invalid @enderror" required>
                                                        @error('phone')
                                                        <div class="invalid-feedback" style="display: block">
                                                            {{ $message }}
                                                        </div>
                                                        @enderror
                                                    </div>

                                                    <div class="modal-footer">
                                                        <button type="submit" class="btn btn-primary btn-submit">
                                                            <i class="fa fa-paper-plane"></i> Simpan
                                                        </button>
                                                        <button class="btn btn-warning text-white btn-reset" type="reset">
                                                            <i class="fa fa-redo"></i> Reset
                                                        </button>
                                                        <button type="button" class="btn btn-default" data-dismiss="modal">
                                                            <i class="fas fa-undo"></i> Kembali
                                                        </button>
                                                    </div>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal fade" id="modal-import">
                                    <div class="modal-dialog modal-lg">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h4 class="modal-title">Import Excel Cabang</h4>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <form action="{{ route('branch.import-excel') }}" method="POST" enctype="multipart/form-data">
                                                @csrf
                                                <div class="modal-body">
                                                    <div class="alert alert-info">
                                                        <h5><i class="icon fas fa-info-circle"></i> Informasi:</h5>
                                                        <p class="mb-0">Format Excel harus sesuai dengan template yang disediakan.</p>
                                                        <p class="mb-0">Kolom yang diperlukan: <strong>Nama Cabang, Alamat, No. Telepon</strong></p>
                                                        <p class="mb-0">Silakan download template terlebih dahulu.</p>
                                                    </div>

                                                    <div class="mb-3">
                                                        <a href="{{ route('branch.download-template') }}" class="btn btn-success btn-sm">
                                                            <i class="fas fa-download"></i> Download Template Excel
                                                        </a>
                                                    </div>

                                                    <div class="form-group">
                                                        <label>Pilih File Excel <span class="text-danger">*</span></label>
                                                        <div class="custom-file">
                                                            <input type="file" name="excel_file" class="custom-file-input" id="excel_file_branch" accept=".xlsx,.xls" required>
                                                            <label class="custom-file-label" for="excel_file_branch">Pilih file...</label>
                                                        </div>
                                                        <small class="form-text text-muted">Format: .xlsx atau .xls (Maksimal 2MB)</small>
                                                    </div>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="submit" class="btn btn-primary">
                                                        <i class="fas fa-upload"></i> Import
                                                    </button>
                                                    <button type="button" class="btn btn-default" data-dismiss="modal">
                                                        <i class="fas fa-undo"></i> Kembali
                                                    </button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                             @endcan
                        </div>
                    </div>
                    <div class="card-body">
                        <table id="example1" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th scope="col" style="text-align: center;width: 6%">NO.</th>
                                    <th scope="col">Nama Cabang</th>
                                    <th scope="col">Alamat</th>
                                    <th scope="col">NO WhatsApp</th>
                                    <th scope="col" style="width: 15%;text-align: center">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $nomer = 1; ?>
                                @foreach ($branches as $no => $branch)
                                <tr>
                                    <th>{{ $nomer++}}</th>
                                    <td>{{ $branch->name }}</td>
                                    <td>{{ $branch->address }}</td>
                                    <td>{{ $branch->phone }}</td>
                                    <td class="text-left">
                                        @can('branches.edit')
                                            <button type="button" class="btn btn-warning text-white btn-sm m-1" title="Edit" data-toggle="modal" data-target="#modal-edit-{{ $branch->id }}">
                                                <i class="fas fa-pencil-alt"></i>
                                            </button>
                                            <div class="modal fade" id="modal-edit-{{ $branch->id }}">
                                                <div class="modal-dialog modal-xl">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h4 class="modal-title"> Edit Data </h4>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <form action="{{ route('branch.update', $branch->id) }}" method="POST" enctype="multipart/form-data" class="form-edit-branch">
                                                            @csrf
                                                            @method('PUT')
                                                            <div class="modal-body">
                                                                <div class="form-group">
                                                                    <label>Nama Cabang <span class="text-danger">*</span></label>
                                                                    <input type="text" name="name" value="{{ old('name', $branch->name) }}" placeholder="Masukkan Nama Cabang" class="form-control @error('name') is-invalid @enderror" required>
                                                                    @error('name')
                                                                    <div class="invalid-feedback" style="display: block">
                                                                        {{ $message }}
                                                                    </div>
                                                                    @enderror
                                                                </div>
                                                                <div class="form-group">
                                                                    <label>Alamat <span class="text-danger">*</span></label>
                                                                    <textarea name="address" placeholder="Masukkan Alamat"
                                                                        class="form-control @error('address') is-invalid @enderror"
                                                                        required>{{ old('address', $branch->address) }}</textarea>
                                                                    @error('address')
                                                                    <div class="invalid-feedback" style="display: block">
                                                                        {{ $message }}
                                                                    </div>
                                                                    @enderror
                                                                </div>
                                                                <div class="form-group">
                                                                    <label>NO WhatsApp <span class="text-danger">*</span></label>
                                                                    <input type="text" name="phone" value="{{ old('phone', $branch->phone) }}" placeholder="Masukkan NO WhatsApp" class="form-control @error('phone') is-invalid @enderror" required>
                                                                    @error('phone')
                                                                    <div class="invalid-feedback" style="display: block">
                                                                        {{ $message }}
                                                                    </div>
                                                                    @enderror
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="submit" class="btn btn-primary btn-submit">
                                                                    <i class="fa fa-paper-plane"></i> Simpan
                                                                </button>
                                                                <button class="btn btn-warning text-white btn-reset" type="reset">
                                                                    <i class="fa fa-redo"></i> Reset
                                                                </button>
                                                                <button type="button" class="btn btn-default" data-dismiss="modal">
                                                                    <i class="fas fa-undo"></i> Kembali
                                                                </button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        @endcan
                                        @can('branches.delete')
                                            <form action="{{ route('branch.delete', $branch->id) }}" method="POST" style="display:inline;" class="delete-form-{{ $branch->id }}">
                                                @csrf
                                                @method('DELETE')
                                                <button type="button" class="btn btn-danger btn-sm delete m-1" data-id="{{ $branch->id}}" data-name="{{ $branch->name}}" title="Hapus">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        @endcan
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- /.content -->

@endsection

@push('scripts')
<script>
    // Update file input label when file is selected
    $('#excel_file_branch').on('change', function() {
        var fileName = $(this).val().split('\\').pop();
        $(this).next('.custom-file-label').html(fileName);
    });
</script>
@endpush



