<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no" name="viewport">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title>Dashboard &mdash; SMK INDONESIA</title>
    <link rel="shortcut icon" href="<?php echo e(asset('assets/img/school.svg')); ?>" type="image/x-icon">
    <!-- General CSS Files -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/modules/bootstrap/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/modules/fontawesome/css/all.min.css')); ?>">

    <!-- CSS Libraries -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/modules/select2/dist/css/select2.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/select2-bootstrap4.css')); ?>" />

    <!-- Template CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/components.css')); ?>">

    <script src="<?php echo e(asset('assets/modules/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/sweetalert.min.js')); ?>"></script>

</head>

<body style="background: #e2e8f0">
    <div id="app">
        <div class="main-wrapper main-wrapper-1">
            <div class="navbar-bg"></div>
            <nav class="navbar navbar-expand-lg main-navbar">
                <form class="form-inline mr-auto">
                    <ul class="navbar-nav mr-3">
                        <li><a href="#" data-toggle="sidebar" class="nav-link nav-link-lg"><i
                                    class="fas fa-bars"></i></a></li>
                    </ul>
                </form>
                <ul class="navbar-nav navbar-right">

                    <li class="dropdown"><a href="#" data-toggle="dropdown"
                            class="nav-link dropdown-toggle nav-link-lg nav-link-user">
                            <img alt="image" src="<?php echo e(asset('assets/img/avatar/avatar-1.png')); ?>"
                                class="rounded-circle mr-1">
                            <div class="d-sm-none d-lg-inline-block">Hi, <?php echo e(auth()->user()->name); ?></div>
                        </a>
                        <div class="dropdown-menu dropdown-menu-right">
                            <a href="<?php echo e(route('logout')); ?>" style="cursor: pointer" onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();"
                                class="dropdown-item has-icon text-danger">
                                <i class="fas fa-sign-out-alt"></i> Logout
                            </a>
                            <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
                                <?php echo csrf_field(); ?>
                            </form>
                        </div>
                    </li>
                </ul>
            </nav>
            <div class="main-sidebar sidebar-style-2">
                <aside id="sidebar-wrapper">
                    <div class="sidebar-brand">
                        <a href="index.html">SMK INDONESIA</a>
                    </div>
                    <div class="sidebar-brand sidebar-brand-sm">
                        <a href="index.html">SMK</a>
                    </div>
                    <ul class="sidebar-menu">
                        <li class="menu-header">MAIN MENU</li>
                        <li class="<?php echo e(setActive('admin/dashboard')); ?>"><a class="nav-link" href="<?php echo e(route('admin.dashboard.index')); ?>">
                            <i class="fas fa-tachometer-alt"></i> <span>Dashboard</span></a>
                        </li>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('posts.index')): ?>
                            <li class="<?php echo e(setActive('admin/post')); ?>"><a class="nav-link" href="<?php echo e(route('admin.post.index')); ?>">
                                <i class="fas fa-book-open"></i> <span>Berita</span></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('tags.index')): ?>
                            <li class="<?php echo e(setActive('admin/tag')); ?>"><a class="nav-link" href="<?php echo e(route('admin.tag.index')); ?>">
                                <i class="fas fa-tags"></i> <span>Tags</span></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('categories.index')): ?>
                            <li class="<?php echo e(setActive('admin/category')); ?>"><a class="nav-link" href="<?php echo e(route('admin.category.index')); ?>">
                                <i class="fas fa-folder"></i> <span>Kategori</span></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('events.index')): ?>
                            <li class="<?php echo e(setActive('admin/event')); ?>"><a class="nav-link" href="<?php echo e(route('admin.event.index')); ?>">
                                <i class="fas fa-bell"></i> <span>Agenda</span></a>
                            </li>
                        <?php endif; ?>

                        <?php if(auth()->user()->can('photos.index') || auth()->user()->can('videos.index')): ?>
                            <li class="menu-header">GALERI</li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('photos.index')): ?>
                            <li class="<?php echo e(setActive('admin/photo')); ?>"><a class="nav-link" href="<?php echo e(route('admin.photo.index')); ?>">
                                <i class="fas fa-image"></i> <span>Foto</span></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('videos.index')): ?>
                            <li class="<?php echo e(setActive('admin/video')); ?>"><a class="nav-link" href="<?php echo e(route('admin.video.index')); ?>">
                                <i class="fas fa-video"></i> <span>Video</span></a>
                            </li>
                        <?php endif; ?>

                        <?php if(auth()->user()->can('roles.index') || auth()->user()->can('permission.index') || auth()->user()->can('users.index')): ?>
                            <li class="menu-header">PENGATURAN</li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('sliders.index')): ?>
                            <li class="<?php echo e(setActive('admin/slider')); ?>"><a class="nav-link" href="<?php echo e(route('admin.slider.index')); ?>">
                                <i class="fas fa-laptop"></i> <span>Sliders</span></a>
                            </li>
                        <?php endif; ?>

                        <li
                            class="dropdown <?php echo e(setActive('admin/role'). setActive('admin/permission'). setActive('admin/user')); ?>">
                            <?php if(auth()->user()->can('roles.index') || auth()->user()->can('permission.index') || auth()->user()->can('users.index')): ?>
                                <a href="#" class="nav-link has-dropdown"><i class="fas fa-users"></i><span>Users
                                Management</span></a>
                            <?php endif; ?>

                            <ul class="dropdown-menu">
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('roles.index')): ?>
                                    <li class="<?php echo e(setActive('admin/role')); ?>"><a class="nav-link" href="<?php echo e(route('admin.role.index')); ?>"><i class="fas fa-unlock"></i> Roles</a>
                                </li>
                                <?php endif; ?>

                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('permissions.index')): ?>
                                    <li class="<?php echo e(setActive('admin/permission')); ?>"><a class="nav-link" href="<?php echo e(route('admin.permission.index')); ?>"><i class="fas fa-key"></i>Permissions</a></li>
                                <?php endif; ?>

                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('users.index')): ?>
                                    <li class="<?php echo e(setActive('admin/user')); ?>"><a class="nav-link" href="<?php echo e(route('admin.user.index')); ?>"><i class="fas fa-users"></i> Users</a>
                                    </li>
                                <?php endif; ?>
                            </ul>
                        </li>
                    </ul>
                </aside>
            </div>

            <!-- Main Content -->
            <?php echo $__env->yieldContent('content'); ?>

            <footer class="main-footer">
                <div class="footer-left">
                    Copyright &copy; 2018 <div class="bullet"></div> SMK INDONESIA <div class="bullet"></div> All Rights
                    Reserved.
                </div>
                <div class="footer-right">

                </div>
            </footer>
        </div>
    </div>

    <!-- General JS Scripts -->
    <script src="<?php echo e(asset('assets/modules/popper.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/modules/bootstrap/js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/modules/nicescroll/jquery.nicescroll.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/stisla.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/modules/select2/dist/js/select2.full.min.js')); ?>"></script>

    <!-- JS Libraies -->

    <!-- Page Specific JS File -->

    <!-- Template JS File -->
    <script src="<?php echo e(asset('assets/js/scripts.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/custom.js')); ?>"></script>
    <script>
        //active select2
        $(document).ready(function () {
            $('select').select2({
                theme: 'bootstrap4',
                width: 'style',
            });
        });

        //flash message
        <?php if(session()->has('success')): ?>
        swal({
            type: "success",
            icon: "success",
            title: "BERHASIL!",
            text: "<?php echo e(session('success')); ?>",
            timer: 1500,
            showConfirmButton: false,
            showCancelButton: false,
            buttons: false,
        });
        <?php elseif(session()->has('error')): ?>
        swal({
            type: "error",
            icon: "error",
            title: "GAGAL!",
            text: "<?php echo e(session('error')); ?>",
            timer: 1500,
            showConfirmButton: false,
            showCancelButton: false,
            buttons: false,
        });
        <?php endif; ?>
    </script>
</body>
</html>
<?php /**PATH C:\xampp8\htdocs\sekolah\resources\views/layouts/app.blade.php ENDPATH**/ ?>