<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class PreserveAnomalyData
{
    public function handle(Request $request, Closure $next)
    {
        // Backup anomaly data
        $anomalyBackup = session('container_anomalies', null);
        $countBackup = session('last_container_count', null);
        $hashBackup = session('last_container_hash', null);
        
        $response = $next($request);
        
        // Restore if lost (except logout/upload)
        if (empty(session('container_anomalies')) && !empty($anomalyBackup)) {
            $isLogout = $request->is('logout') || $request->is('baplie/clear-session');
            $isNewUpload = $request->is('baplie/upload') && $request->isMethod('POST');
            
            if (!$isLogout && !$isNewUpload) {
                session()->put('container_anomalies', $anomalyBackup);
                if (!empty($countBackup)) session()->put('last_container_count', $countBackup);
                if (!empty($hashBackup)) session()->put('last_container_hash', $hashBackup);
                
                Log::warning('🔄 Anomaly data restored by middleware', [
                    'route' => $request->path(),
                    'total_anomalies' => $anomalyBackup['summary']['total_anomalies'] ?? 0,
                ]);
            }
        }
        
        return $response;
    }
}