<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class DashboardController extends Controller
{
    /**
     * Display dashboard with voyage and container data from session
     */
     public function index()
    {
        $voyage = session('voyage', []);
        $containers = session('containers', []);

        if (empty($voyage) && empty($containers)) {
            return view('baplie_management')->with('error', 'Tidak ada data BAPLIE di session. Silakan unggah file BAPLIE terlebih dahulu.');
        }

        return view('baplie_management', compact('voyage', 'containers'));
    }
}
